#ifndef _OGG_STREAM_SOURCE_H_INCLUDED
#define _OGG_STREAM_SOURCE_H_INCLUDED

#include "config.h"

#ifdef HAVE_LIBVORBIS

#include "jack.h"
#include <vorbis/vorbisfile.h>
#include <stdio.h>

class OggStreamSource : public StreamSource
{
Q_OBJECT

public:
	OggStreamSource(QWidget *dest);
	~OggStreamSource();

	int attach(QString name);
	int get_buffer(char *, int);
	int play(unsigned long start_frame, unsigned long samples, bool loop=false);
	int stop(void);
	void exit_loop(void);
	StreamSource *get_source(void);
private:
	FILE *fp;
	OggVorbis_File ov;
	unsigned long file_pos;
	int stream_num;
};
#endif /* HAVE_LIBVORBIS */
#endif
