/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "config.h"
#include "mixerpanel-background.xpm"
#include "plugins/bitmapbutton/bitmapbutton.h" 
#include "plugins/bitmapslider/bitmapslider.h" 

void MixerPanel::init()
{
    background=new QPixmap((const char **)mixerpanel_background_xpm);
    meter=new Meter(this, 0, WRepaintNoErase);
    meter->setGeometry(67, 15, 24, 154);
	player_number=0;
    meterset=0;
    player=0;
    eq=0;
    pfl_mix=0;
    Gain->setValue(30);
}

void MixerPanel::destroy()
{
    if(meterset)
    {
	pump->removeMeters(meterset);
	delete meterset;
    }
#ifdef HAVE_LADSPA
    if(eq)
    {
	player->removeEffect(eq);
	delete eq;
    }
#endif
    if(pfl_mix)
    {
	player->removeEffect(pfl_mix);
	delete pfl_mix;
    }
    delete background;
}

void MixerPanel::setMainWnd( int channel_number, MainWnd *m )
{
    QString title;
    title.sprintf("Channel %d", channel_number);
//    Name->setTitle(title);
    mainwnd=m;
	player_number=channel_number;
    pump=mainwnd->get_pump();
    player=mainwnd->get_player();
    meterset=new MeterSet;
    meterset->setMeters(meter);
	meterset->setPlayer(player);
    pump->addMeters(meterset);
    Gain_valueChanged(Gain->value());
    pfl_mix=new MixEffect;
    Frame *frame=(Frame*)mainwnd->parent();
    pfl_mix->left()->setPort(frame->pfl_left);
    pfl_mix->right()->setPort(frame->pfl_right);
    pfl_mix->setControl(0, 0.0);
    player->addEffect(pfl_mix);
#ifdef HAVE_LADSPA
    eq=new LadspaEffect;
    eq->loadEffect(player->client->rate(), 1901, "dj_eq");
    if(!eq || eq->ports() == 0)
    {
	if(eq)
		delete eq;
	eq=0;
	Low->hide();
	Mid->hide();
	High->hide();
    }
    else
    {
	player->addEffect(eq);
	connect(Low, SIGNAL(valueChanged(int)), this, SLOT(lowChanged(int)));
	connect(Mid, SIGNAL(valueChanged(int)), this, SLOT(midChanged(int)));
	connect(High, SIGNAL(valueChanged(int)), this, SLOT(highChanged(int)));
    }
#else
	Low->hide();
	Mid->hide();
	High->hide();
#endif
}



void MixerPanel::lowChanged( int val )
{
    portChanged(0, val);
}


void MixerPanel::midChanged( int val )
{
    portChanged(1, val);
}


void MixerPanel::highChanged( int val )
{
    portChanged(2, val);
}


void MixerPanel::portChanged( int port, int val )
{
#ifdef HAVE_LADSPA
    float v;
    if(val <= 0)
	v=(float)val/100.0*70.0;
    else
	v=(float)val/100.0*24.0;
    eq->setControl(port, v);
#endif
}


void MixerPanel::Reset_clicked()
{
    if(eq)
    {
	Low->setValue(0);
	Mid->setValue(0);
	High->setValue(0);
    }
}


void MixerPanel::Gain_valueChanged( int val )
{
    val=100-val;
    double gain;
    if(val <= 70)
	gain=(double)val/70;
    else
	gain=1.0+(double)(val-70)/20;
    if(player)
	player->setGain(gain);
    if(meterset)
	meterset->setMeterFactor(gain*0.8, gain*0.8);
}


void MixerPanel::Pfl_toggled( bool on)
{
	frame->set_led(player_number-1, PFL_LED, on);
    emit pfl(player, on);
    if(pfl_mix)
	pfl_mix->setControl(0, on ? 1.0 : 0.0);
}


Effect * MixerPanel::effect()
{
    return pfl_mix;
}


void MixerPanel::paintEvent( QPaintEvent *e )
{
    bitBlt(this, 0, 0, background);
}
