#ifndef _CFGFILE_H_INCLUDED
#define _CFGFILE_H_INCLUDED

#include <qvaluelist.h>

class Config;

class ConfigItem
{
protected:
	QString key;
	QString value;

friend class Config;
};

class Config
{
public:
	Config();
	Config(QString app, bool i_save=true);
	Config(Config&);
	~Config();

	void setValue(QString key, QString value);
	void setSave(bool i_save);
	void setName(const char *i_name);
	QString getValue(QString key, QString def);
	Config& operator = (Config&);
	QString name();

protected:
	QValueList<ConfigItem>::Iterator findItem(QString key);
	bool s_save;
	void save();
	void load();

	QValueList<ConfigItem> items;
	QString appName;
};

#endif
