/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <gnome.h>
#include "appglobals.h"
#include "appsupport.h"
#include "prefs.h"

void
load_prefs (void)
{

  FILE *fd;
  gchar buf[1024];
  gchar **split = NULL;
  gchar *homedir = NULL;
  gchar *cfgfile = NULL;
  connection_profile *connprof = NULL;

  gboolean is_default;

  homedir = g_get_home_dir ();

/*
   this reads user creation defaults
   this is also supposed to be read with a lexical scanner from
   /etc/login.defs
*/
  preferences.logindefaults.PASS_MIN_DAYS = 0;
  preferences.logindefaults.PASS_MAX_DAYS = 30;
  preferences.logindefaults.PASS_WARN_AGE = 7;
  preferences.logindefaults.PASS_INACTIVE_AGE = 2;
  preferences.logindefaults.PASS_MIN_LEN = 5;
  preferences.logindefaults.VUID_MIN = 500;
  preferences.logindefaults.VUID_MAX = 60000;
  preferences.logindefaults.VGID_MIN = 500;
  preferences.logindefaults.VGID_MAX = 60000;
  gint tls;



/*
   this reads available shells
   this is read from /etc/shells, but zeroed first
*/


  preferences.logindefaults.shells = NULL;

  //now reading shells
  fd = fopen ("/etc/shells", "r");
  if (fd)
    {
      while (fgets (buf, sizeof (buf), fd) != NULL)
	{
	  // Skip comments and empty lines...
	  if (*buf == '\n' || *buf == '#')
	    continue;

	  // Remove newline at the end...
	  buf[strlen (buf) - 1] = '\0';

	  preferences.logindefaults.shells =
	    g_list_append (preferences.logindefaults.shells, g_strdup (buf));
	}
      fclose (fd);
    }


  preferences.passwordcrypttype =
    gnome_config_get_int_with_default
    ("/directoryadmin/settings/passwordcrypttype=0", &is_default);


  preferences.rfc2307bis =
    gnome_config_get_bool_with_default
    ("/directoryadmin/settings/rfc2307bis=0", &is_default);

  preferences.userbox.sambaused =
    gnome_config_get_bool_with_default
    ("/directoryadmin/settings/sambaused=0", &is_default);


  preferences.userbox.lastgroup =
    gnome_config_get_string_with_default
    ("/directoryadmin/settings/lastgroup=0", &is_default);
//			 g_print("Loaded last group: %s\n",preferences.userbox.lastgroup);

  preferences.avoidconflicts =
    gnome_config_get_bool_with_default
    ("/directoryadmin/settings/avoidconflicts=1", &is_default);

  preferences.avoidconflictscope =
    gnome_config_get_int_with_default
    ("/directoryadmin/settings/avoidconflictscope=1", &is_default);

  connection_profile_list = NULL;


// now scanning profile config file
  cfgfile = g_strconcat (homedir, "/.directory_administrator/profiles", NULL);
  fd = fopen (cfgfile, "r");
  if (fd)
    {
      while (!feof (fd))
	{
	  while (fgets (buf, sizeof (buf), fd))
	    {
	      if (*buf == '\n' || *buf == '#')
		continue;
	      buf[strlen (buf) - 1] = '\0';
	      split = g_strsplit (buf, "|", 0);
	      if ( (!(strcmp(split[4],"Y"))) || (!(strcmp(split[4],"N"))) )
	      {
	        if (!(strcmp(split[4],"Y")))
		  tls = 1;
	        else
	          tls = 0;
	        connprof =
		  connection_profile_new (split[0], split[1],
		  			split[2], split[3], tls, split[5]);
	        if (split[5])
		  {
		    if (split[6])
		      {
		        connection_profile_set_last_user_ou (connprof,
			  				   split[6]);
		        if (split[7])
			  connection_profile_set_last_group_ou (connprof,
			  				      split[7]);
		      }
		  }
              }
	      else // for backwards compatibility with prev versions
              {
                tls = 0;
	        connprof =
		  connection_profile_new (split[0], split[1],
		                          split[2], split[3], tls, split[4]);
	        if (split[4])
		  {
		    if (split[5])
		      {
		        connection_profile_set_last_user_ou (connprof,
			                                     split[5]);
		        if (split[6])
			  connection_profile_set_last_group_ou (connprof,
			                                        split[6]);
		      }
		  }
	      }
	      connection_profile_list =
		g_list_append (connection_profile_list, connprof);
	      g_strfreev (split);
	    }
	}
      fclose (fd);
    }
  g_free (cfgfile);

  current_connection_profile = NULL;

}


void
save_prefs (void)
{

  FILE *fd;
  int dd;
  struct stat *statbuf = NULL;
  gchar *homedir = NULL;
  gchar *cfgfile = NULL;

  GList *loopix = NULL;

  homedir = g_get_home_dir ();

  cfgfile = g_strconcat (homedir, "/.directory_administrator", NULL);
  statbuf = g_new (struct stat, 1);
  dd = stat (cfgfile, statbuf);
  if (dd)
    {
      if (errno == ENOENT)
	{
	  mkdir (cfgfile, 0700);
	}
      else
	{
	  perror ("while saving preferences: opendir failed");
	  exit (1);
	}
    }
  g_free (statbuf);
  g_free (cfgfile);

  //now saving profile list
  cfgfile = g_strconcat (homedir, "/.directory_administrator/profiles", NULL);
  loopix = g_list_first (connection_profile_list);
  fd = fopen (cfgfile, "w");
  if (fd)
    {
      while (loopix)
	{
	  if (connection_profile_get_name (loopix->data))
	    fprintf (fd, "%s", connection_profile_get_name (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_dn (loopix->data))
	    fprintf (fd, "%s", connection_profile_get_dn (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_password (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_password (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_server (loopix->data))
	    fprintf (fd, "%s", connection_profile_get_server (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_tls (loopix->data))
	    fprintf (fd, "%s", "Y");
	  else
	    fprintf (fd, "%s", "N");
	  fprintf (fd, "|");
	  if (connection_profile_get_treeroot (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_treeroot (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_last_user_ou (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_last_user_ou (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_last_group_ou (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_last_group_ou (loopix->data));
	  fprintf (fd, "\n");
	  loopix = g_list_next (loopix);
	}
      fclose (fd);
    }
  g_free (cfgfile);


  /*now saving password crypt type */
  gnome_config_set_int ("/directoryadmin/settings/passwordcrypttype",
			preferences.passwordcrypttype);

  /*now saving rfc behavior */
  gnome_config_set_bool ("/directoryadmin/settings/rfc2307bis",
			 preferences.rfc2307bis);

/*now saving samba checkbox */
  gnome_config_set_bool ("/directoryadmin/settings/sambaused",
			 preferences.userbox.sambaused);

/*now saving last group */
  gnome_config_set_string ("/directoryadmin/settings/lastgroup",
			 preferences.userbox.lastgroup);
//			 g_print("Saving last group: %s\n",preferences.userbox.lastgroup);

  gnome_config_set_bool ("/directoryadmin/settings/avoidconflicts",
			preferences.avoidconflicts);
  gnome_config_set_int ("/directoryadmin/settings/avoidconflictscope",
			preferences.avoidconflictscope);


  /*save all data */
  gnome_config_sync ();
}


//this function saves the preference changes of the dialog in memory
//returns TRUE if everything went okay
//returns FALSE in case there is a format or something else error
gboolean
process_preferences_dialog (GnomeDialog * gnomedialog)
{

  GtkWidget *dialogbox = GTK_WIDGET (gnomedialog);

  g_print ("\nCalled process preferences dialog\n");

  // saving modifications
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_cleartext"))->active)
    {
      g_print ("password type: cleartext");
      preferences.passwordcrypttype = CLEARTEXT;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_crypt"))->active)
    {
      g_print ("password type: crypt");
      preferences.passwordcrypttype = CRYPT;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_md5"))->active)
    {
      g_print ("password type: md5sum");
      preferences.passwordcrypttype = MD5;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_extended"))->active)
    {
      g_print ("password type: extended");
      preferences.passwordcrypttype = EXTENDED;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "rfc2307bis"))->active)
    {
      preferences.rfc2307bis = TRUE;
    }
  if (!GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "rfc2307bis"))->active)
    {
      preferences.rfc2307bis = FALSE;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "avoidconflicts"))->active)
      preferences.avoidconflicts = TRUE;
 else
      preferences.avoidconflicts = FALSE;

  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "entiredirectory"))->active)
      preferences.avoidconflictscope = ENTIREDIR;
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "sameorgunit"))->active)
      preferences.avoidconflictscope = ORGUNIT;

  return (TRUE);
}
