#include "pairs.h"

// ojo se tiene que irr!!!

pairs_list *
pairs_list_append (pairs_list * list, gchar * uno, gchar * dos)
{
  //just pass two string pointers.  I will duplicate and free them later.

  pair *pairs;

  if ((dos) && (strlen (dos) > 0))
    {
      pairs = g_new (pair, 1);
      pairs->attribute = g_strdup (uno);
      pairs->value = g_strdup (dos);
      return (g_list_append (list, pairs));
    }
  else
    return g_list_first (list);

}

gchar *
pairs_list_get_attribute (pairs_list * list, gchar * attribute)
{

  pair *pairs;
  pairs_list *reference = g_list_first (list);

  while (reference)
    {
      pairs = reference->data;
      if (g_strcasecmp (attribute, pairs->attribute) == 0)
	return pairs->value;
      reference = g_list_next (reference);
    }
  return (NULL);

}

pairs_list *
pairs_list_set_attribute (pairs_list * list, gchar * attribute, gchar * value)
{

  if (pairs_list_get_attribute (list, attribute))
    list = pairs_list_remove_attribute (list, attribute);

  return (pairs_list_append (list, attribute, value));

}

pairs_list *
pairs_list_remove_attribute (pairs_list * list, gchar * attribute)
{

  pair *pairs = NULL;
  pairs_list *iterator = NULL;
  pairs_list *firstitem = NULL;

  firstitem = g_list_first (list);
  iterator = g_list_first (list);
  while (iterator)
    {
      pairs = iterator->data;
      if (g_strcasecmp (attribute, pairs->attribute) == 0)
	{
	  g_free (pairs->attribute);
	  g_free (pairs->value);
	  g_free (pairs);
	  firstitem = g_list_remove (iterator, iterator->data);
	}
      iterator = g_list_next (iterator);
    }
  return (firstitem);

}

void
pairs_list_destroy (pairs_list * list)
{
  pair *pairs = NULL;
  pairs_list *list2 = g_list_first (list);
  list = g_list_first (list);
  while (list)
    {
      pairs = list->data;
/*     g_print("Freeing data from pair: "); g_print(pairs->attribute);
     g_print(pairs->value);
 */
      g_free (pairs->attribute);
      g_free (pairs->value);
      g_free (pairs);
      list = g_list_next (list);
    }
  g_list_free (list2);

}

pairs_list *
pairs_list_duplicate (pairs_list * list)
{

  pairs_list *oldlist = NULL;
  pairs_list *newlist = NULL;
  pair *pairs = NULL;

  oldlist = g_list_first (list);
  while (oldlist)
    {
      pairs = list->data;
      newlist = pairs_list_append (newlist, pairs->attribute, pairs->value);
      oldlist = g_list_next (oldlist);
    }
  return (newlist);

}
