#include "appsupport.h"
#include "profile.h"
#include "appglobals.h"
#include "appfunctions.h"
#include "usergrouplists.h"
#include "connect_dialog.h"

void
profileselected_fill (GtkWidget * widget)
{

  GList *loopix = g_list_first (connection_profile_list);
  GList *milista = NULL;

  g_assert (widget);

  while (loopix)
    {

      milista = g_list_append (milista,
			       g_strdup (connection_profile_get_name
					 ((connection_profile *)
					  loopix->data)));
      loopix = g_list_next (loopix);
    }

  gtk_combo_set_popdown_strings (GTK_COMBO (widget), milista);


  g_list_foreach (milista, (GFunc) g_free, NULL);
  g_list_free (milista);

}


int
profileselected_commit (GtkWidget * widget)
{
  gchar *profilename = NULL;
  int ldap_error_definition;

  g_print ("\ncalled: profileselected_commit\n");
  profilename =
    gtk_entry_get_text (GTK_ENTRY
			(lookup_widget (widget, "profileselectedentry")));
  g_assert (profilename);

  ///DESTROY AND FREE THE ARGUMENT!!!!! SET IT TO NULL AFTER DESTROYING IT PLEASE!!!!!!!!!!!!
  connection_profile_destroy (current_connection_profile);
  current_connection_profile = NULL;

  //gimme a copy of the selected one and point the current one to the copy
  current_connection_profile =
    connection_profile_duplicate (connection_profile_list_getbyname
				  (connection_profile_list, profilename));

  ldap_error_definition =
    connection_profile_connect (current_connection_profile);
  if (ldap_error_definition)
    {
      gtk_widget_show (create_messagebox_with_message
		       (ldap_err2string (ldap_error_definition)));
      gtk_toggle_button_set_active ((GtkToggleButton *)
				    lookup_widget (app, "button_connect"),
				    FALSE);
      connection_profile_destroy (current_connection_profile);
      current_connection_profile = NULL;
    }
  return (ldap_error_definition);
}
