#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <errno.h>
#include <lber.h>
#include <ldap.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "appglobals.h"
#include "users.h"
#include "groups.h"
#include "appfunctions.h"
#include "prefsdialog.h"
#include "usergrouplists.h"
#include "modifydialogs.h"
#include "newdruids.h"
#include "connect_dialog.h"
#include "prefs.h"
#include "icon_entry.h"

void
on_exit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_main_quit ();
}


void
on_cut1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_copy1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_paste1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_clear1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_preferences1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_widget_show (create_preferences ());

}


void
on_about1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_widget_show (create_about ());
}


void
on_mainwindow_destroy (GtkObject * object, gpointer user_data)
{
  gtk_main_quit ();
}


void
on_button4_clicked (GtkButton * button, gpointer user_data)
{
  if (on_button4_clicked_handler (button, (GtkWidget *) user_data) == TRUE)
    gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "login"));

}


void
on_login_destroy (GtkObject * object, gpointer user_data)
{
  gtk_object_destroy (object);
}






void
on_login_cancel_button_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "login"));
}


void
on_button_add_profile_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *about = create_login ();


  gtk_signal_connect (GTK_OBJECT (lookup_widget (about, "button4")),
		      "clicked", GTK_SIGNAL_FUNC (on_button4_clicked),
		      lookup_widget ((GtkWidget *) button, "list_profiles"));
  gtk_widget_show (about);

}


void
on_button_connect_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  GtkWidget *about;
  if (GTK_TOGGLE_BUTTON ((GtkToggleButton *) togglebutton)->active)
    {
      g_print("El boton esta presionado\n");
      //are there any profiles?
      if (g_list_length (connection_profile_list))
	{
//          g_print("Existen perfiles de conexion\n");
	  GtkWidget *about = create_connect_selectprofile ();
	  gtk_widget_show (about);
	}
      else
	{
	  g_print ("no existing profiles, please create one!\n");

	  //if not, prompt me to create one
          g_print("No existen perfiles de conexion\n");
	  gtk_toggle_button_set_active (togglebutton, FALSE);

	  about = create_login ();
	  gtk_signal_connect (GTK_OBJECT (lookup_widget (about, "button4")),
			      "clicked", GTK_SIGNAL_FUNC (on_button4_clicked),
			      NULL);
	  gtk_widget_show (about);
	  gtk_widget_show (create_messagebox_with_message
			   ("Please create a new connection profile"));

	  return (FALSE);
	}

    }
  else
    {
      connection_profile_disconnect (current_connection_profile);

//turn off buttons
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "button_new"),
				FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "button_new_group"), FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "button_modifyselection"), FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "button_removeselection"), FALSE);
//turn off menus
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "new_user2"),
				FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "new_group1"), FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "modify1"),
				FALSE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "remove1"), FALSE);

      //this has the effect of emptying user lists
      fill_iconlist (current_connection_profile);
    }


}



void
on_button_test_connection_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *mesg;
  connection_profile *test;
  int ldap_errors;

  gchar *nombrecitocojudo;

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server"));
      return;
    }

  test =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));
  ldap_errors = connection_profile_connect (test);

  if (ldap_errors)
    mesg = create_messagebox_with_message (ldap_err2string (ldap_errors));
  ////THIS IS ONLY DEBUG BEHAVIOR!! REMOVE BEFORE SHIPPING!!!!!
  else
    {
      mesg = create_messagebox_with_message ("The connection was successful");
    }

  gtk_widget_show (mesg);
  connection_profile_destroy (test);

}


void
on_list_profiles_map (GtkWidget * widget, gpointer user_data)
{

  list_profiles_fill (widget);

}


void
on_button_remove_profile_clicked (GtkButton * button, gpointer user_data)
{
  gint selected_crap = (gint) user_data;
  gchar *profilename = NULL;
  connection_profile *conprof = NULL;

  GtkWidget *profile_list =
    (GtkWidget *) lookup_widget ((GtkWidget *) button, "list_profiles");

  gtk_clist_get_text ((GtkCList *) profile_list, selected_crap, 0,
		      &profilename);

  //if profilename is null, just return, because it means nothing is selected;
  if (profilename == NULL)
    return;

  // this used to be the handler:  g_assert(profilename);

  conprof =
    connection_profile_list_getbyname (connection_profile_list, profilename);
  if (conprof == NULL)
    {
      g_print ("***ERROR! could not get data about selected profile");
      return;
    }

  connection_profile_list =
    connection_profile_list_remove (connection_profile_list, conprof);

  gtk_clist_remove ((GtkCList *)
		    lookup_widget ((GtkWidget *) button, "list_profiles"),
		    selected_crap);

}

void
on_button_modify_profile_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *about = NULL;
  gint selected_crap = (gint) user_data;
  gchar *profilename = NULL;
  GtkWidget *profile_list =
    (GtkWidget *) lookup_widget ((GtkWidget *) button, "list_profiles");

  gtk_clist_get_text ((GtkCList *) profile_list, selected_crap, 0,
		      &profilename);

  //if profilename is null, just return, because it means nothing is selected;
  g_assert (profilename);

  about = create_login ();

  fill_login (about, profilename);
  gtk_signal_connect (GTK_OBJECT (lookup_widget (about, "button4")),
		      "clicked", GTK_SIGNAL_FUNC (on_login_modify_finish),
		      profile_list);

  gtk_widget_show (about);


}


void
on_list_profiles_select_row (GtkCList * clist,
			     gint row,
			     gint column,
			     GdkEvent * event, gpointer user_data)
{

  GtkWidget *button_remove_profile =
    lookup_widget ((GtkWidget *) clist, "button_remove_profile");
  GtkWidget *button_modify_profile =
    lookup_widget ((GtkWidget *) clist, "button_modify_profile");

  printf ("\nSelected row %d\n", row);

  gtk_signal_disconnect (GTK_OBJECT (button_remove_profile),
			 preferences_profile_list_signal_reference);
  gtk_signal_disconnect (GTK_OBJECT (button_modify_profile),
			 preferences_profile_list_signal_reference2);

  preferences_profile_list_signal_reference =
    gtk_signal_connect (GTK_OBJECT (button_remove_profile), "clicked",
			GTK_SIGNAL_FUNC (on_button_remove_profile_clicked),
			(gpointer) row);
  preferences_profile_list_signal_reference2 =
    gtk_signal_connect (GTK_OBJECT (button_modify_profile), "clicked",
			GTK_SIGNAL_FUNC (on_button_modify_profile_clicked),
			(gpointer) row);

}


void
on_client_setup1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *about = create_druid_client_setup ();
  gtk_widget_show (about);

}


void
on_enableperserverlogon_toggled (GtkToggleButton * togglebutton,
				 gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_show (lookup_widget
		       (GTK_WIDGET (togglebutton), "label_serverid"));
      gtk_widget_show (lookup_widget (GTK_WIDGET (togglebutton), "serverid"));
      /* If control reaches here, the toggle button is down */

    }
  else
    {
      gtk_widget_hide (lookup_widget
		       (GTK_WIDGET (togglebutton), "label_serverid"));
      gtk_widget_hide (lookup_widget (GTK_WIDGET (togglebutton), "serverid"));
      /* If control reaches here, the toggle button is up */
    }

}



void
on_button_add_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_button_up_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_button_down_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_button_remove_shell_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_loginshells_map (GtkWidget * widget, gpointer user_data)
{

  fill_loginshells_list (widget);

}


void
on_loginshells_select_row (GtkCList * clist,
			   gint row,
			   gint column, GdkEvent * event, gpointer user_data)
{

  GtkWidget *button_up_shell =
    lookup_widget ((GtkWidget *) clist, "button_up_shell");
  GtkWidget *button_down_shell =
    lookup_widget ((GtkWidget *) clist, "button_down_shell");
  GtkWidget *button_remove_shell =
    lookup_widget ((GtkWidget *) clist, "button_remove_shell");

  printf ("\nSelected row %d\n", row);

  gtk_signal_disconnect (GTK_OBJECT (button_up_shell),
			 preferences_loginshells_signal_reference);
  gtk_signal_disconnect (GTK_OBJECT (button_down_shell),
			 preferences_loginshells_signal_reference2);
  gtk_signal_disconnect (GTK_OBJECT (button_remove_shell),
			 preferences_loginshells_signal_reference3);

  preferences_loginshells_signal_reference =
    gtk_signal_connect (GTK_OBJECT (button_up_shell), "clicked",
			GTK_SIGNAL_FUNC (on_button_up_shell_clicked),
			(gpointer) row);
  preferences_loginshells_signal_reference2 =
    gtk_signal_connect (GTK_OBJECT (button_down_shell), "clicked",
			GTK_SIGNAL_FUNC (on_button_down_shell_clicked),
			(gpointer) row);
  preferences_loginshells_signal_reference3 =
    gtk_signal_connect (GTK_OBJECT (button_remove_shell), "clicked",
			GTK_SIGNAL_FUNC (on_button_remove_shell_clicked),
			(gpointer) row);


}


void
on_minuid_map (GtkWidget * widget, gpointer user_data)
{
  char buf[256];
  g_snprintf (buf, 256, "%d", preferences.logindefaults.VUID_MIN);
  gtk_entry_set_text (GTK_ENTRY (widget), buf);
}


void
on_mingid_map (GtkWidget * widget, gpointer user_data)
{
  char buf[256];
  g_snprintf (buf, 256, "%d", preferences.logindefaults.VGID_MIN);
  gtk_entry_set_text (GTK_ENTRY (widget), buf);

}


void
on_profileselected_map (GtkWidget * widget, gpointer user_data)
{
  profileselected_fill (widget);
}



void
on_selectprofile_okay_clicked (GtkButton * button, gpointer user_data)
{

  if (!profileselected_commit (GTK_WIDGET (button)))
    {
      gtk_widget_destroy (lookup_widget
			  (GTK_WIDGET (button), "connect_selectprofile"));
      fill_iconlist (current_connection_profile);
      gtk_widget_set_sensitive (lookup_widget (app, "button_new"), TRUE);
      gtk_widget_set_sensitive (lookup_widget (app, "button_new_group"),
				TRUE);
      gtk_widget_set_sensitive (lookup_widget (app, "new_user2"), TRUE);
      gtk_widget_set_sensitive (lookup_widget (app, "new_group1"), TRUE);
    }

}


void
  on_connect_selectprofile_cancel_clicked
  (GtkButton * button, gpointer user_data)
{
  gtk_toggle_button_set_active ((GtkToggleButton *)
				lookup_widget (app, "button_connect"), FALSE);
  gtk_widget_destroy (lookup_widget
		      (GTK_WIDGET (button), "connect_selectprofile"));

}


void
on_cancel_clicked (GtkButton * button, gpointer user_data)
{

}


void
on_modifygroup_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "modifygroup"));

}


void
on_modifyuser_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) button, "modifyuser"));

}


void
on_button_modifyselection_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *mainwindow;
  GnomeIconList *itemlist = NULL;
  gint pos;
  icon_entry *entry;
  itemlist =
    (GnomeIconList *) lookup_widget (GTK_WIDGET (button), "itemlist");

  g_assert (itemlist->selection);

  pos = GPOINTER_TO_INT (itemlist->selection->data);
  entry = gnome_icon_list_get_icon_data (itemlist, pos);

  if (entry->type == DIRADMIN_USER)
    {
      mainwindow = create_modifyuser ();
      gtk_widget_show (mainwindow);
      fill_modifyuser (mainwindow, entry->name);	// - should be DN!!!!
    }
  if (entry->type == DIRADMIN_GROUP)
    {
      mainwindow = create_modifygroup ();
      gtk_widget_show (mainwindow);
      fill_modifygroup (mainwindow, entry->name);	// - should be DN!!!!
    }

}


void
on_logontoallservers_toggled (GtkToggleButton * togglebutton,
			      gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_hide (lookup_widget
		       (GTK_WIDGET (togglebutton), "frame_loginservers"));
      /* If control reaches here, the toggle button is down */

    }
  else
    {
      gtk_widget_show (lookup_widget
		       (GTK_WIDGET (togglebutton), "frame_loginservers"));
      /* If control reaches here, the toggle button is up */
    }

}


void
on_button_new_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *mainwindow = NULL;

  if (connection_profile_is_connected (current_connection_profile))
    {

      mainwindow = create_druid_new_user ();

      gtk_widget_show (mainwindow);


    }

}


void
on_druid_new_user_druid_cancel (GnomeDruid * gnomedruid, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_new_user"));
}


void
on_button_passwd_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_show (lookup_widget (GTK_WIDGET (button), "tablepassword"));
  gtk_widget_destroy (GTK_WIDGET (button));

}


void
on_adduser_togroup_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  GtkWidget *about = create_selectuser ();
  memberlist = (GtkCList *) lookup_widget (GTK_WIDGET (button), "members");
  gtk_object_set_user_data (GTK_OBJECT (about), memberlist);
  gtk_widget_show (about);

}


void
on_userselected_map (GtkWidget * widget, gpointer user_data)
{
  fill_users_dropdown (widget);

}


void
on_selectuser_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  GtkWidget *mywindow = NULL;
  char *row[2];
  row[0] = NULL;
  row[1] = NULL;

  mywindow = lookup_widget (GTK_WIDGET (button), "selectuser");
  memberlist = (GtkCList *) gtk_object_get_user_data (GTK_OBJECT (mywindow));

  row[0] =
    gtk_entry_get_text (GTK_ENTRY
			(lookup_widget
			 (GTK_WIDGET (button), "userselectedentry")));
  if (row[0])
    {
      gtk_clist_append (memberlist, row);
    }
  gtk_widget_destroy (mywindow);
}


void
on_selectuser_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "selectuser"));

}


void
on_deluser_fromgroup_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  memberlist = (GtkCList *) lookup_widget (GTK_WIDGET (button), "members");
  if (memberlist->selection)
    {
      gtk_clist_remove (memberlist,
			GPOINTER_TO_INT (memberlist->selection->data));
    }

}


void
on_addserver_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  GtkWidget *about = create_addserver ();
  memberlist =
    (GtkCList *) lookup_widget (GTK_WIDGET (button), "allowedservers");
  gtk_object_set_user_data (GTK_OBJECT (about), memberlist);
  gtk_widget_show (about);

}


void
on_delserver_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  memberlist =
    (GtkCList *) lookup_widget (GTK_WIDGET (button), "allowedservers");
  if (memberlist->selection)
    {
      gtk_clist_remove (memberlist,
			GPOINTER_TO_INT (memberlist->selection->data));
    }

}


void
on_addserver_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *memberlist = NULL;
  GtkWidget *mywindow = NULL;
  char *row[1];
  row[0] = NULL;

  mywindow = lookup_widget (GTK_WIDGET (button), "addserver");
  memberlist = (GtkCList *) gtk_object_get_user_data (GTK_OBJECT (mywindow));

  row[0] =
    gtk_entry_get_text (GTK_ENTRY
			(lookup_widget
			 (GTK_WIDGET (button), "selectedserver")));
  if (strlen (row[0]) == 0)
    {
      mywindow =
	create_messagebox_with_message ("You need to supply a server name");
      gtk_widget_show (mywindow);
    }
  else
    {
      gtk_clist_append (memberlist, row);
      gtk_widget_destroy (mywindow);
    }
}


void
on_addserver_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "addserver"));

}


void
on_druid_new_profile_druid_cancel (GnomeDruid * gnomedruid,
				   gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_new_profile_user"));

}


void
on_druid_client_setup_druid_cancel (GnomeDruid * gnomedruid,
				    gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_client_setup"));

}



void
on_modifyuser_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *window = NULL;

  window = lookup_widget (GTK_WIDGET (button), "modifyuser");
  if (modifyuser_check (window) == OK)
    if (modifyuser_commit (window) == OK)
      gtk_widget_destroy (window);

}





void
on_modifygroup_okay_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *window = NULL;

  window = lookup_widget (GTK_WIDGET (button), "modifygroup");
  if (modifygroup_check (window) == OK)
    if (modifygroup_commit (window) == OK)
      gtk_widget_destroy (window);

}



void
on_givenname_changed (GtkEditable * editable, gpointer user_data)
{
  //aqui y en la sig. funcion hay fuga de memoria en el strdelimit
  GtkEntry *cn, *sn, *givenname, *uid;
  gchar *text;
  gchar newdel = '_';

  cn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "cn"));
  sn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "sn"));
  givenname = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "givenname"));
  uid = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "uid"));

  gtk_editable_delete_text (GTK_EDITABLE (cn), 0, -1);
  gtk_entry_set_text (cn,
		      gtk_editable_get_chars (GTK_EDITABLE (givenname), 0,
					      -1));
  gtk_entry_append_text (cn, " ");
  gtk_entry_append_text (cn,
			 gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));

  gtk_editable_delete_text (GTK_EDITABLE (uid), 0, -1);

  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (givenname), 0, 1));
  g_strdown (text);
  gtk_entry_set_text (uid, text);
  g_free (text);
  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));
  g_strdown (text);
  text = g_strdelimit (text, G_STR_DELIMITERS, newdel);
  gtk_entry_append_text (uid, text);
  g_free (text);
}


void
on_sn_changed (GtkEditable * editable, gpointer user_data)
{
  GtkEntry *cn, *sn, *givenname, *uid;
  gchar *text;
  gchar newdel = '_';

  cn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "cn"));
  sn = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "sn"));
  givenname = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "givenname"));
  uid = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "uid"));

  gtk_editable_delete_text (GTK_EDITABLE (cn), 0, -1);
  gtk_entry_set_text (cn,
		      gtk_editable_get_chars (GTK_EDITABLE (givenname), 0,
					      -1));
  gtk_entry_append_text (cn, " ");
  gtk_entry_append_text (cn,
			 gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));

  gtk_editable_delete_text (GTK_EDITABLE (uid), 0, -1);

  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (givenname), 0, 1));
  g_strdown (text);
  gtk_entry_set_text (uid, text);
  g_free (text);
  text = g_strdup (gtk_editable_get_chars (GTK_EDITABLE (sn), 0, -1));
  g_strdown (text);
  text = g_strdelimit (text, G_STR_DELIMITERS, newdel);
  gtk_entry_append_text (uid, text);
  g_free (text);
}


void
on_uid_changed (GtkEditable * editable, gpointer user_data)
{
  GtkEntry *homedirectory, *uid;

  homedirectory =
    GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "homedirectory"));
  uid = GTK_ENTRY (lookup_widget (GTK_WIDGET (editable), "uid"));

  gtk_editable_delete_text (GTK_EDITABLE (homedirectory), 0, -1);
  gtk_entry_set_text (homedirectory, "/home/");
  gtk_entry_append_text (homedirectory,
			 gtk_editable_get_chars (GTK_EDITABLE (uid), 0, -1));

}


gboolean
on_druidpageessential_next (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  if (strlen
      (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "givenname"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter the given name"));
      return (TRUE);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "sn"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter the last name"));
      return (TRUE);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "cn"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter a common name for the user"));
      return (TRUE);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uid"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter a user ID"));
      return (TRUE);
    }
  return FALSE;
}


gboolean
on_druidpageaccesscontrol_next (GnomeDruidPage * gnomedruidpage,
				gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  if (strlen
      (gtk_entry_get_text
       (GTK_ENTRY (lookup_widget (window, "userpassword")))) == 0
      &&
      strlen (gtk_entry_get_text
	      (GTK_ENTRY (lookup_widget (window, "userpasswordconfirm")))) ==
      0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a password"));
      return (TRUE);
    }
  if (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "userpassword")))
      &&
      gtk_entry_get_text (GTK_ENTRY
			  (lookup_widget (window, "userpasswordconfirm")))
      &&
      strcmp (gtk_entry_get_text
	      (GTK_ENTRY (lookup_widget (window, "userpassword"))),
	      gtk_entry_get_text (GTK_ENTRY
				  (lookup_widget
				   (window, "userpasswordconfirm")))) != 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Passwords do not match"));
      return (TRUE);
    }
  return (FALSE);
}


gboolean
on_druidpageunixaccount_next (GnomeDruidPage * gnomedruidpage,
			      gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  gdouble test;
  gchar *gidnumber = NULL;

  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticuid"))->active ==
      FALSE)
    {
      gidnumber =
	gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "uidnumber")));
      test = g_strtod (gidnumber, NULL);
      if (strlen (gidnumber) == 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Type a number in the UNIX UID number entry"));
	  return (TRUE);
	}
      if (test == 0 && g_strcasecmp ("0", gidnumber) != 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Invalid UNIX UID number"));
	  return (TRUE);
	}
    }
  if (strlen
      (gtk_entry_get_text
       (GTK_ENTRY (lookup_widget (window, "homedirectory")))) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a home directory"));
      return (TRUE);
    }
  return (FALSE);
}


void
on_druidpagefinish3_finish (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");
  if (newuser_commit (gnomedruidpage) == OK)
    gtk_widget_destroy (window);
}


void
on_uidnumber_map (GtkWidget * widget, gpointer user_data)
{
}


void
on_button_removeselection_clicked (GtkButton * button, gpointer user_data)
{

  gtk_widget_show (create_deleteselection ());
}


gboolean
on_druidpagegroupinfo_next (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_group");
  gdouble test;
  gchar *gidnumber = NULL;
  if (strlen (gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "cn"))))
      == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("Please enter a group name"));
      return (TRUE);
    }
  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticgid"))->active ==
      FALSE)
    {
      gidnumber =
	gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "gidnumber")));
      test = g_strtod (gidnumber, NULL);
      if (strlen (gidnumber) == 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Type a number in the UNIX GID number entry"));
	  return (TRUE);
	}
      if (test == 0 && g_strcasecmp ("0", gidnumber) != 0)
	{
	  gtk_widget_show (create_messagebox_with_message
			   ("Invalid UNIX GID number"));
	  return (TRUE);
	}
    }


  return FALSE;
}


void
on_button_new_group_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *mainwindow = NULL;

  if (connection_profile_is_connected (current_connection_profile))
    {

      mainwindow = create_druid_new_group ();
      gtk_widget_show (mainwindow);

    }

}


void
on_gidnumber_map (GtkWidget * widget, gpointer user_data)
{

}


void
on_druid_new_group_druid_cancel (GnomeDruid * gnomedruid, gpointer user_data)
{
  gtk_widget_destroy (lookup_widget ((GtkWidget *) gnomedruid,
				     "druid_new_group"));

}


void
on_druidpagefinish4_finish (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  GtkWidget *window =
    lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_group");
  if (newgroup_commit (gnomedruidpage) == OK)
    gtk_widget_destroy (window);

}


void
on_enablemailpolicycontrol_toggled (GtkToggleButton * togglebutton,
				    gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_show (lookup_widget (GTK_WIDGET (togglebutton), "frame6"));

    }
  else
    {
      gtk_widget_hide (lookup_widget (GTK_WIDGET (togglebutton), "frame6"));
    }

}


void
on_mailroutingaddressset_toggled (GtkToggleButton * togglebutton,
				  gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "mailroutingaddress"), TRUE);

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton),
				 "mailroutingaddress"), FALSE);
    }

}


void
on_mailhostset_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "mailhost"),
				TRUE);

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "mailhost"),
				FALSE);
    }

}


void
on_user_baseoudropdown_map (GtkWidget * widget, gpointer user_data)
{
  g_print ("\ncalled: on_user_baseoudropdown_map\n");
  gtk_combo_set_popdown_strings (GTK_COMBO (widget),
				 get_user_ou_list
				 (current_connection_profile));
  if (connection_profile_get_last_user_ou
      (connection_profile_list_getbyname
       (connection_profile_list,
	connection_profile_get_name (current_connection_profile))))

    gtk_entry_set_text (GTK_ENTRY
			(lookup_widget (widget, "baseou")),
			connection_profile_get_last_user_ou
			(connection_profile_list_getbyname
			 (connection_profile_list,
			  connection_profile_get_name
			  (current_connection_profile))));



}


void
on_group_baseoudropdown_map (GtkWidget * widget, gpointer user_data)
{
  g_print ("\ncalled: on_group_baseoudropdown_map\n");
  gtk_combo_set_popdown_strings (GTK_COMBO (widget),
				 get_group_ou_list
				 (current_connection_profile));
  if (connection_profile_get_last_group_ou
      (connection_profile_list_getbyname
       (connection_profile_list,
	connection_profile_get_name (current_connection_profile))))

    gtk_entry_set_text (GTK_ENTRY
			(lookup_widget (widget, "baseou")),
			connection_profile_get_last_group_ou
			(connection_profile_list_getbyname
			 (connection_profile_list,
			  connection_profile_get_name
			  (current_connection_profile))));

}

void
on_automaticuid_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "uidnumber"),
				FALSE);
    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "uidnumber"),
				TRUE);
    }

}

void
on_automaticgid_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "gidnumber"),
				FALSE);
    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "gidnumber"),
				TRUE);
    }

}


void
on_loginshellsdropdown_realize (GtkWidget * widget, gpointer user_data)
{

  gtk_combo_set_popdown_strings (GTK_COMBO (widget),
				 preferences.logindefaults.shells);
}

void
on_gidnumberdropdown_realize (GtkWidget * widget, gpointer user_data)
{

  fill_groups_dropdown (widget);
}


gint
on_deleteselection_closed (GnomeDialog * gnomedialog, gpointer user_data)
{
  return (FALSE);
}


void
on_okdeletion_click (GtkButton * button, gpointer user_data)
{
  GnomeIconList *itemlist = NULL;
  icon_entry *entry = NULL;
  gchar *dn = NULL;
  LDAP *conn;
  int ldap_errors = LDAP_SUCCESS;

  itemlist = (GnomeIconList *) lookup_widget (GTK_WIDGET (app), "itemlist");
  conn = connection_profile_get_ldap_handler (current_connection_profile);
  g_assert (itemlist->selection);

  entry =
    gnome_icon_list_get_icon_data (itemlist,
				   GPOINTER_TO_INT (itemlist->selection->
						    data));

  dn = entry->dn;
  ldap_errors = ldap_delete_s (conn, dn);
  if (ldap_errors == LDAP_SUCCESS)
    objectview_remove_bydn (dn);
  else
    gtk_widget_show (create_messagebox_with_message
		     (ldap_err2string (ldap_errors)));
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "deleteselection"));

}


void
on_canceldeletion_click (GtkButton * button, gpointer user_data)
{
// gtk_signal_emit_by_name(GTK_OBJECT(lookup_widget(GTK_WIDGET(button),"deleteselection")),"close");
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "deleteselection"));
}


void
on_preferences_clicked (GnomeDialog * gnomedialog,
			gint arg1, gpointer user_data)
{
  g_print ("\nClicked preferences - processing and closing dialog\n");

  if (arg1 == 0)
    {
      //returns true in case everything went okay
      if (process_preferences_dialog (gnomedialog))
	{
	  save_prefs ();
	  gtk_widget_destroy (GTK_WIDGET (gnomedialog));
	}
    }
  else
    {
      gtk_widget_destroy (GTK_WIDGET (gnomedialog));
    }

}


gint
on_preferences_close (GnomeDialog * gnomedialog, gpointer user_data)
{
  g_print ("\nClosed preferences\n");
  return (TRUE);
}


gboolean
on_preferences_delete_event (GtkWidget * widget,
			     GdkEvent * event, gpointer user_data)
{
  gtk_widget_destroy (widget);
  return FALSE;
}


void
on_pass_crypt_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.passwordcrypttype == CRYPT)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
}


void
on_pass_cleartext_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.passwordcrypttype == CLEARTEXT)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);

}


void
on_pass_md5_map (GtkWidget * widget, gpointer user_data)
{
  if (preferences.passwordcrypttype == MD5)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);

}

void
on_shadowmin_realize (GtkWidget * widget, gpointer user_data)
{
//pass_min_days
  char buf[32];
  if (preferences.logindefaults.PASS_MIN_DAYS)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_MIN_DAYS);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowmax_realize (GtkWidget * widget, gpointer user_data)
{
//pass_max_days
  char buf[32];
  if (preferences.logindefaults.PASS_MAX_DAYS)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_MAX_DAYS);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowwarning_realize (GtkWidget * widget, gpointer user_data)
{
//pass_warn_age
  char buf[32];
  if (preferences.logindefaults.PASS_WARN_AGE)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_WARN_AGE);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowinactive_realize (GtkWidget * widget, gpointer user_data)
{
//pass_inactive_age
  char buf[32];
  if (preferences.logindefaults.PASS_INACTIVE_AGE)
    {
      snprintf (buf, sizeof buf, "%d",
		preferences.logindefaults.PASS_INACTIVE_AGE);
      gtk_entry_set_text (GTK_ENTRY (widget), buf);
    }
}


void
on_shadowexpirecheck_toggled (GtkToggleButton * togglebutton,
			      gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "shadowexpire"),
				TRUE);

    }
  else
    {
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (togglebutton), "shadowexpire"),
				FALSE);

    }
}


void
on_clist_users_realize (GtkWidget * widget, gpointer user_data)
{

  static GtkTargetEntry drag_types[] = {
    {"x-application/x-directoryadmin-group", 0, TARGET_GROUP_DN}
  };

  g_print ("\nCLIST USERS REALIZED\n");
  gtk_drag_source_set (widget,
		       GDK_BUTTON1_MASK,
		       drag_types, ELEMENTS (drag_types), GDK_ACTION_COPY);

}


void
on_members_realize (GtkWidget * widget, gpointer user_data)
{
  static GtkTargetEntry drop_types[] = {
    {"x-application/x-directoryadmin-group", 0, TARGET_GROUP_DN}
  };

  g_print ("\nMember list realized - setting up drop properties\n");
  gtk_drag_dest_set (widget,
		     GTK_DEST_DEFAULT_ALL,
		     drop_types, ELEMENTS (drop_types), GDK_ACTION_COPY);

}


void
on_members_drag_data_received (GtkWidget * widget,
			       GdkDragContext * drag_context,
			       gint x,
			       gint y,
			       GtkSelectionData * data,
			       guint info, guint time, gpointer user_data)
{

  GtkCList *memberlist;
  char *row[2];
  row[0] = NULL;
  row[1] = NULL;

  memberlist = (GtkCList *) widget;

  g_print ("\nData received at %d from %d: %s\n", time, info, data->data);

  row[0] = g_strdup (data->data);
  if (row[0])
    {
      gtk_clist_append (memberlist, row);
    }
}


void
on_clist_users_drag_data_get (GtkWidget * widget,
			      GdkDragContext * drag_context,
			      GtkSelectionData * data,
			      guint info, guint time, gpointer user_data)
{
  GnomeIconList *itemlist;
  int pos;
  gchar *dn = NULL;
  icon_entry *entry = NULL;
  itemlist = (GnomeIconList *) widget;
  if (itemlist->selection)
    {
      pos = GPOINTER_TO_INT (itemlist->selection->data);
      entry = gnome_icon_list_get_icon_data (itemlist, pos);
      dn = entry->dn;
      g_print ("\nSending DN: %s\n", dn);
      gtk_selection_data_set (data,
			      data->target, strlen (dn), dn, strlen (dn));


    }


}


void
focus_me (GtkWidget * widget, gpointer user_data)
{
  gtk_widget_grab_focus (widget);
}


void
on_new_user2_activate (GtkMenuItem * menuitem, gpointer user_data)
{

  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_new")),
			   "clicked");
}


void
on_new_group1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_new_group")),
			   "clicked");

}


void
on_modify1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_modifyselection")),
			   "clicked");

}


void
on_remove1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_signal_emit_by_name (GTK_OBJECT (lookup_widget (GTK_WIDGET (menuitem),
						      "button_removeselection")),
			   "clicked");

}


void
on_itemlist_select_icon (GnomeIconList * gnomeiconlist,
			 gint arg1, GdkEvent * event, gpointer user_data)
{

  icon_entry *entry = (icon_entry *)
    gnome_icon_list_get_icon_data (gnomeiconlist, arg1);
  if (entry)
    {
      g_assert (entry->dn);
//      g_print ("\nSelected icon related to DN: %s\n", entry->dn);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (gnomeiconlist),
				 "button_modifyselection"), TRUE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (gnomeiconlist),
				 "button_removeselection"), TRUE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (gnomeiconlist), "modify1"),
				TRUE);
      gtk_widget_set_sensitive (lookup_widget
				(GTK_WIDGET (gnomeiconlist), "remove1"),
				TRUE);
    }


}


void
on_itemlist_realize (GtkWidget * widget, gpointer user_data)
{
  static GtkTargetEntry drag_types[] = {
    {"x-application/x-directoryadmin-group", 0, TARGET_GROUP_DN}
  };

  g_print ("\nIcon list realized - setting up drag and drop\n");
  gtk_drag_source_set (widget,
		       GDK_BUTTON1_MASK,
		       drag_types, ELEMENTS (drag_types), GDK_ACTION_COPY);


}

void
on_itemlist_drag_data_get (GtkWidget * widget,
			   GdkDragContext * drag_context,
			   GtkSelectionData * data,
			   guint info, guint time, gpointer user_data)
{
  GnomeIconList *itemlist;
  int pos;
  gchar *dn = NULL;
  icon_entry *entry = NULL;
  itemlist = (GnomeIconList *) widget;
  if (itemlist->selection)
    {
      pos = GPOINTER_TO_INT (itemlist->selection->data);
      entry = gnome_icon_list_get_icon_data (itemlist, pos);
      dn = entry->dn;
      g_print ("\nSending DN: %s\n", dn);
      gtk_selection_data_set (data,
			      data->target, strlen (dn), dn, strlen (dn));


    }


}

gboolean
on_itemlist_button_press_event (GtkWidget * widget,
				GdkEventButton * event, gpointer user_data)
{

  icon_list_click_event ((GnomeIconList *) widget, event, user_data);


  return FALSE;
}
