/*
  oz263.h:   Functions for accessing the oz263 chip. Also,
             find and return the SiS96x i2c bus device for
             the digimatrix setpanel program, for both 2.4
             and 2.6 kernels.
  Copyright (c) 2005 Andrew Calkin <calkina@geexbox.org> and
                     Ben Potter <linux@bpuk.org>

  Based heavily on the codebase for the header given directly below,
  and the original setpanel.c code, written by Richard Taylor,
  Ben Potter and Cyril Lacoux.

  Original header:
    i2cbusses: Print the installed i2c busses for both 2.4 and 2.6 kernels.
               Part of user-space programs to access for I2C
               devices.
    Copyright (c) 1999-2003  Frodo Looijaard <frodol@dds.nl> and
                             Mark D. Studebaker <mdsxyz123@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Address on the I2C bus of the AudioDJ (OZ268) IC */
#define AUDIODJ_I2C_ADDRESS       0x49

typedef enum _control
{
	SEEK_DOWN = 0,
	SEEK_UP,
	FINE_TUNE_DOWN,
	FINE_TUNE_UP,
	CHANNEL_PREV,
	CHANNEL_NEXT,
	STORE_START,
	STORE_CANCEL,
	STORE_COMMIT
} CONTROL;

typedef enum _radio_mode
{
    OFF_MODE = 0,
    AM_RADIO,
    FM_RADIO,
    CD_MODE,
    HD_MODE
} RADIO_MODE;

/* Dots are in reg 0x06
    0x00 = No Dots.
    0x01 = middle dot
    0x02 = bottom dot
    0x03 = both dots */
typedef enum _dots
{
    DOTS_NONE = 0,
    DOTS_MIDDLE,
    DOTS_BOTTOM,
    DOTS_BOTH
} DOTS;

/* First digit:
   0x80 of 0x00 makes LED not light up for representative mode.

   All digits:
   0x0f = blank
   0x0e = 'C' (2nd Digit = 'D') CD MODE LED
   0x0d = 'P' (2nd Digit = '-') HD MODE LED
   0x0c = '-' (2nd Digit = 'M') Invalid MODE
   0x0b = 'A'                   AM MODE LED
   0x0a = 'F'                   FM MODE LED
   < 0x0a = Number.i
*/

typedef enum _leds
{
    LED_NONE = 0x8f,
    LED_AM = 0x0b,
    LED_FM = 0x0a,
    LED_CD = 0x0e,
    LED_HD = 0x0d,
} LED;


/* Writing to Reg 0x07 does nothing,
   0x08 = PLAY LED, 0x09 = PAUSE LED */
typedef enum _pp
{
    PP_NONE = 0x07,
    PP_PLAY = 0x08,
    PP_PAUSE = 0x09
} PP;


int find_i2c_sis96x(void);
int oz263_write_byte_data(int file, char reg, char data);
int oz263_write_byte(int file, char data);
int oz263_read_byte(int file);
void oz263_radio_control(int file, CONTROL control);
void oz263_radio_mode(int file, RADIO_MODE radio_mode);
void oz263_display(int file, char digits[6], LED led, PP pp,
                       DOTS dots, BOOL reinit);
int oz263_I2C_init(void);

