/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta funcion inicializa unas cuantas variables globales usadas durante la busqueda
 *******************************************************************************/
void buscar_inicializar(void)
{
	buscar_indice=0;
	buscar_buscando=FALSE;
	buscar_terminado=FALSE;
}

/*******************************************************************************
 Esta funcion muestra la bentana de busqueda y pone en en la entrada
 de busqueda el texto seleccionado
 *******************************************************************************/
void buscar_buscar(void)
{
	GtkWidget *ventana,*boton;
	GtkEditable *editor;
	gchar *seleccion;
	GtkEntry *buscar;

	if ((!buscar_buscando) && (edit_actual!=NULL)) {
		ventana=create_buscar_ventana();
		if (!ejecutables.grep) {
			boton=lookup_widget(ventana,"boton_buscar_multiple_files");
			gtk_widget_set_sensitive(boton,FALSE);
		}
		editor=GTK_EDITABLE(edit_actual->editor);
		buscar=GTK_ENTRY(lookup_widget(ventana,"buscar_entrada"));
		seleccion=gtk_editable_get_chars(editor,editor->selection_start_pos,editor->selection_end_pos);
		if (seleccion != NULL) {
			gtk_entry_set_text(buscar,seleccion);
			g_free(seleccion);
			gtk_widget_grab_focus(lookup_widget(ventana,"buscar_boton"));
		} else {
			gtk_widget_grab_focus(GTK_WIDGET(buscar));
		}
		gtk_widget_show(ventana);
		buscar_indice=0;
		edit_actualizar();
		buscar_buscando=TRUE;
		buscar_terminado=FALSE;
	}
}

/*******************************************************************************
 Realiza la busqueda de la siguiente coincidencia en el texto
 *******************************************************************************/
void buscar_siguiente(GtkWidget *widget)
{
	GtkEntry *entrada;
	GtkWidget *fuente;
	gchar *texto;
	GtkEditable *editor;
	gchar *seleccion;
	gchar mayusculas;

	editor=GTK_EDITABLE(edit_actual->editor);
	entrada=GTK_ENTRY(lookup_widget(widget,"buscar_entrada"));
	texto=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	fuente=lookup_widget(widget,"sensibilidad_boton_busqueda");
	mayusculas=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente));
	//Si la busqueda es "from cursor", no empezaria desde la posicion 0 sino 
	//desde la posicion actual
	if ((estado_botones.from_cursor == TRUE) && (buscar_indice == 0)){
		buscar_indice = gtk_editable_get_position(editor);
	}
		 
	if (mayusculas) {
		seleccion=strstr(&((edit_actual->datos)[buscar_indice]),texto);
	} else {
		seleccion=strcasestr(&((edit_actual->datos)[buscar_indice]),texto);
	}
	if (seleccion!=NULL) {
		buscar_indice=((guint)seleccion)-((guint)(edit_actual->datos));
		edit_ir_a_posicion(buscar_indice,edit_actual->filas);
		gtk_editable_set_position(editor,buscar_indice);
		edit_actualizar_fila();
		editor->has_selection=0;
		gtk_editable_select_region(editor,buscar_indice,buscar_indice+strlen(texto));
		buscar_indice++;
	} else {
		buscar_terminado=TRUE;
	}
	g_free(texto);
}

/*******************************************************************************
 Busca la siguiente coincidencia y la reemplaza
 *******************************************************************************/
void buscar_reemplazar(GtkWidget *widget)
{
	GtkEntry *entrada;
	gchar *texto;
	GtkEditable *editor;

	edit_actualizar();
	editor=GTK_EDITABLE(edit_actual->editor);
	widget=gtk_widget_get_toplevel(widget);
	entrada=GTK_ENTRY(lookup_widget(widget,"reemplazar_entrada"));
	texto=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);

	widget = gtk_widget_get_toplevel(widget);
	buscar_siguiente(widget);

	gtk_editable_delete_selection(editor);
	if ((texto!=NULL) && (!buscar_terminado)){
		buscar_indice--;
		gtk_editable_insert_text(editor,texto,strlen(texto),&buscar_indice);
	}
	g_free(texto);
}

/*******************************************************************************
 Hace una busqueda por todo el texto y reemplaza las coincidencias
 *******************************************************************************/
void buscar_reemplazar_todo(GtkWidget *widget)
{
	do {
		buscar_reemplazar(widget);
	} while (!buscar_terminado);
}

/*************************************************************************************
 Esta funcion busca un nodo como hijo de otro nodo que se le pasa como
parametro y te devuelve un puntero a ese nodo, o NULL en caso de que no exista
**************************************************************************************/
xmlNodePtr buscar_nodo_xml (xmlNodePtr padre, gchar *nombre_nodo)
{ 
	xmlNodePtr nodo = NULL;
	
	if (padre != NULL) {
		/*Nos situamos en el primer hijo*/
		nodo = padre->childs;
		while (nodo != NULL) {
			if (!strcmp (nodo->name, nombre_nodo))
				return nodo;
			else 
				nodo = nodo->next;
		}
	}
	return nodo;
}

/***********************************************************************************************
Esta funcion realiza la busqueda de un texto introducido por el usuario por los 
ficheros elegidos por el usuario en la ventana de busqueda. Presenta los resultados
en la ventana de mensajes y cierra la ventana de busqueda.
**********************************************************************************************/
int buscar_busqueda(GtkWidget *ventana_busqueda)
{
	GtkEntry *entrada;
	GtkWidget *widget;
	gchar *texto_escapado, *comando, *archivos, *tmp;
	gchar *nombre, *nombre_completo, *lista_others = NULL, *lista_others_tmp = NULL;
	gboolean estado;
	xmlNodePtr xmlnode;
	
	//Recogemos el texto a buscar y las opciones de busqueda
	//Guardamos la cadena de busqueda en una variable global para usarla desde
	//otras partes
	if (texto_busqueda_actual != NULL)
		g_free(texto_busqueda_actual);
	entrada = GTK_ENTRY(lookup_widget(ventana_busqueda,"buscar_entrada"));
	texto_busqueda_actual = gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	//case sensitive
	widget = lookup_widget(ventana_busqueda,"sensibilidad_boton_busqueda");
	estado_botones.sensitive = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
	//archivo actual o multiples archivos
	widget = lookup_widget(ventana_busqueda,"boton_buscar_current_file");
	estado = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
	estado_botones.current = estado;
	estado_botones.multiple = (!estado);	
	if (estado_botones.current) { //Archivo actual
		widget = lookup_widget(ventana_busqueda,"todo_boton_zona_busqueda");
		estado = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		estado_botones.all_document = estado;
		estado_botones.from_cursor = (!estado);
		//Buscamos con el codigo viejo
		buscar_siguiente(ventana_busqueda);
		if (buscar_terminado) {
			edit_mensaje(_("No more maches."));
		}
	} else { //multiples archivos
		//activamos el flag de busqueda
		widget = lookup_widget(ventana_busqueda,"boton_buscar_all_sources");
		estado_botones.sources = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		widget = lookup_widget(ventana_busqueda,"boton_buscar_all_headers");
		estado_botones.headers = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		widget = lookup_widget(ventana_busqueda,"boton_buscar_all_others");
		estado_botones.others = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		//Generamos el comando GREP para realizar la busqueda, comprobando que se haya elegido
		//algun grupo de ficheros
		if ((!estado_botones.sources) && (!estado_botones.headers) && (!estado_botones.others))	{
			//avisar al usuario que tiene que elegir un grupo por lo menos
			return (-1);
		}
		//Generamos la lista de archivos en los que buscar
		archivos = g_strdup("");
		if (estado_botones.sources) { 
			g_free(archivos);
			archivos = g_strconcat ("*.c *.cpp *.c++ *.cc ",NULL);
		}		
		if (estado_botones.headers) {
			tmp =g_strdup(archivos);
			g_free(archivos);
			archivos = g_strconcat (tmp,"*.h *.hh ",NULL);
			g_free(tmp);
		}
		if (estado_botones.others) {
			tmp = g_strdup(archivos);
			g_free(archivos);
			xmlnode = buscar_nodo_xml(proyecto.xml->root, "otros");
			if (xmlnode != NULL) {
				//Nos situamos en el primer hijo
				xmlnode = xmlnode->childs;
				if (xmlnode != NULL) {
					do {  //concatenamos todos los nombres de archivos de OTHERS
						nombre = xmlNodeGetContent (xmlnode);
						nombre_completo = pro_nombre_completo_archivo(nombre, FALSE);
						if (lista_others != NULL) {   //el primer elemento no pasa por aqui
							lista_others_tmp = g_strdup(lista_others);
							g_free(lista_others);
							lista_others = g_strconcat(lista_others_tmp," ", nombre_completo, NULL);
						} else {
							lista_others = g_strconcat(nombre_completo, NULL);
						}
						g_free(nombre);
						g_free(nombre_completo);
						if (lista_others_tmp != NULL)
							g_free(lista_others_tmp);
						xmlnode = xmlnode->next;
					} while (xmlnode != NULL);
				} //fin del if
			} //fin del if
			archivos = g_strconcat (tmp, lista_others, NULL);
			g_free(tmp);
			g_free(lista_others);
		}			
		//"escapamos" la cadena a buscar, para que no tenga caracteres con un significado especial para GREP
		texto_escapado = buscar_escapar_cadena_grep (texto_busqueda_actual);
		g_print(_("Searching for: %s"),texto_busqueda_actual);
		if (estado_botones.sensitive)
			comando = g_strdup_printf ("grep -Hn '%s' %s\n", texto_escapado,archivos);
		else
			comando = g_strdup_printf ("grep -Hni '%s' %s\n", texto_escapado,archivos);
		//Cerramos la ventana de busqueda y mostramos la de mensajes
		gen_cerrar_ventana(ventana_busqueda);
		edit_mensaje("");
		widget=lookup_widget(david_ventana,"mensajes_togglebutton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
		//Nos situamos en el directorio de los Sources
		pro_nombre_completo_archivo("cualquier_cosa.c",TRUE);
		//Y ejecutamos el comando
		if (gen_comando(comando,NULL)==-1) {
			g_print(_("error\n"));
		} else {
			g_print(_("Search Finished\n"));
		}
		
		buscar_buscando = FALSE;
		g_free(comando);
		g_free(archivos);
		g_free(texto_escapado);
	}	
return 0;
}

/******************************************************************************************
Esta funcion se encarga de "escapar" los metacaracteres que tienen un
significado especial para GREP al hacer una busqueda. Hay que liberar la
variable que devuelve cuando no se vaya a usar mas.
******************************************************************************************/
gchar *buscar_escapar_cadena_grep (char *cadena_original)
{
	gchar *cadena_escapada = NULL;
	guint cont = 0, cont_escapada = 0;
	guint numero_caracteres = 0;

	//Primero contamos el numero de caracteres especiales que tiene la cadena original
	while (cadena_original[cont] != '\0') {
		switch (cadena_original[cont]) {
			case '\'':
				  //este caso es especial 
				numero_caracteres = numero_caracteres +3;	
				break;
			case '[':
			case ']':
			case '.':
			case '$':
			case '\\':
			case '^':
			case '-':	
				numero_caracteres++;
				break;
		} //fin del switch
		cont++;
	} //fin del while 
	
	//reservamos memoria para la nueva cadena_escapada
	cadena_escapada = g_malloc(strlen(cadena_original)+numero_caracteres+1);
	
	//Y ahora gbuscar_nodo_xmleneramos la cadena_escapada
	cont = 0;
	while (cadena_original[cont] != '\0') {
		switch (cadena_original[cont]) {
			case '\'':
				cadena_escapada[cont_escapada++]='\'';
				cadena_escapada[cont_escapada++]='\\';
				cadena_escapada[cont_escapada++]='\'';
				cadena_escapada[cont_escapada] = cadena_original[cont];  
				break;
			case '[':
			case ']':
			case '.':
			case '$':
			case '\\':
			case '^':
			case '-':
				cadena_escapada[cont_escapada++] = '\\';
				cadena_escapada[cont_escapada] = cadena_original[cont];
				break;
			default:
				cadena_escapada[cont_escapada] = cadena_original[cont];
				break;
		}//fin del switch				
		cont++;
		cont_escapada++;
	}//fin del while
	//Por ultimo, le ponemos el '\0' a la cadena_escapada
	cadena_escapada[cont_escapada]='\0';

	return (cadena_escapada);
}