/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/pp_config.hpp
 *
 * $Id: pp_config.hpp,v 1.3 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] The marcos used to reflect the code --
 * compiler dependent configuration: @ref DIAGNOSTICS_BASE_FILE and
 * @ref DIAGNOSTICS_FUNC_NAME.
 *
 * @test none
 */
#ifndef DIAGNOSTICS__MACROS__PP_CONFIG_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__MACROS__PP_CONFIG_HPP__INCLUDE_GUARD

/**
 * @brief Guard for __BASE_FILE__
 */
#ifndef __BASE_FILE__
#  define __BASE_FILE__ ""
#endif

/**
 * @brief The base file of the current preprocessing
 */
#ifndef DIAGNOSTICS_BASE_FILE
#  define DIAGNOSTICS_BASE_FILE __BASE_FILE__
#endif

/**
 * @brief Pretty printed function name
 */
#ifndef DIAGNOSTICS_FUNC_NAME
#ifndef WIN32
#  define DIAGNOSTICS_FUNC_NAME __PRETTY_FUNCTION__
#else
#  define DIAGNOSTICS_FUNC_NAME __FUNCSIG__ 
#endif
#endif

#endif

// vim:ts=4:sw=4
