/* dia-shape-view-info.h
 *
 * Copyright (C) 2004  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* dia-shape-view-info.h
 * -----------
 * Glue code for shapes and view items.
 */
#ifndef __DIA_SHAPE_VIEW_INFO_H__
#define __DIA_SHAPE_VIEW_INFO_H__

#include <glib.h>
#include <libart_lgpl/art_vpath.h>
#include <libart_lgpl/art_vpath_dash.h>
#include <libart_lgpl/art_bpath.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <diacanvas/dia-shape.h>
#include <diacanvas/dia-canvas-view.h>

G_BEGIN_DECLS

typedef struct _DiaShapeViewInfo DiaShapeViewInfo;

/* Function used to free the DiaShapeViewInfo */
typedef void (* DiaShapeViewInfoFree) (DiaCanvasViewItem *item,
				       DiaShapeViewInfo *item_info);

/**
 * DiaShapeViewInfo
 * @key: The address of the #DiaCanvasViewItem who created this shape
 * 	information object.
 * @free_func: Pointer to a function that is used to free @data.
 * @data: View specific information.
 *
 * #DiaShapeViewInfo is used to let #DiaCanvasView's add view specific
 * information to a shape.
 **/
struct _DiaShapeViewInfo
{
	DiaShape *shape;
	
	DiaShapeViewInfoFree free_func; 

	gpointer data;
};

DiaShapeViewInfo *dia_shape_view_info_new (DiaShape *shape);
DiaShapeViewInfo *dia_shape_view_info_get (DiaCanvasViewItem *item, DiaShape *shape);

void dia_shape_view_info_free (DiaCanvasViewItem *item, DiaShapeViewInfo *view_info);

//void dia_shape_view_info_clear (DiaShapeViewInfo *view_info);
//void dia_shape_view_info_remove (DiaShape *shape, DiaShapeViewInfo *view_info);


G_END_DECLS

#endif /* __DIA_SHAPE_VIEW_INFO_H__ */
