/* dia-shape-view-info.c
 * Copyright (C) 2004  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "dia-shape-view-info.h"


DiaShapeViewInfo*
dia_shape_view_info_new (DiaShape *shape)
{
	DiaShapeViewInfo *view_info = NULL;

	view_info = g_new0 (DiaShapeViewInfo, 1);
	view_info->shape = shape;
	return view_info;
}

/**
 * dia_shape_view_info_get:
 * @item: 
 * @shape: 
 *
 * Find the DiaShapeViewInfo that belongs to @key. In most cases @key
 * is the #DiaCanvasViewItem object that draws the shape.
 *
 * Return value: 
 **/
DiaShapeViewInfo*
dia_shape_view_info_get (DiaCanvasViewItem *item, DiaShape *shape)
{
	GSList *l;

	for (l = item->view_info; l != NULL; l = g_slist_next(l))
		if (((DiaShapeViewInfo*) l->data)->shape == shape)
			return l->data;

	//g_warning ("Shape %p not found in view info list", shape);
	return NULL;
}

void
dia_shape_view_info_free (DiaCanvasViewItem *item, DiaShapeViewInfo *view_info)
{
	g_return_if_fail (DIA_IS_CANVAS_VIEW_ITEM (item));

	if (view_info->free_func)
		view_info->free_func (item, view_info);
	view_info->free_func = NULL;
	view_info->data = NULL;
	g_free (view_info);
}

/**
 * dia_shape_view_info_clear:
 * @view_info: 
 *
 * Empty the @view_info structure.
 **/
/*
void
dia_shape_view_info_clear (DiaShapeViewInfo *view_info)
{
	if (view_info->free_func)
		view_info->free_func (item, view_info);
	view_info->free_func = NULL;
	view_info->data = NULL;
}
*/
/**
 * dia_shape_view_info_remove:
 * @shape: 
 * @view_info: 
 *
 * Remove @view_info from the shape. @view_info is also freed.
 **/
/*
void
dia_shape_view_info_remove (DiaCanvasViewInfo *item, DiaShapeViewInfo *view_info)
{
	g_return_if_fail (DIA_IS_CANVAS_VIEW_ITEM (item));
	dia_shape_view_info_clear (view_info);
	shape->view_info = g_list_remove (shape->view_info, view_info);
	g_free (view_info);
}
*/
