/* dia-canvas-editable.c
 * Copyright (C) 2003 Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "dia-canvas-iter.h"

/**
 * dia_canvas_iter_init:
 * @iter:
 *
 * Initialize the iterator @iter with some neuteral values.
 **/
void
dia_canvas_iter_init(DiaCanvasIter *iter)
{
	g_return_if_fail (iter != NULL);

	iter->data[0] = NULL;
	iter->data[1] = NULL;
	iter->data[2] = NULL;
	iter->destroy_func = NULL;
	iter->stamp = 0;
}

/**
 * dia_canvas_iter_destroy:
 * @iter:
 *
 * Indicate that the iterator is no longer used. if iter->destroy_func
 * is set, it is executed.
 **/
void
dia_canvas_iter_destroy(DiaCanvasIter *iter)
{
	g_return_if_fail (iter != NULL);

	if (iter->destroy_func) {
		iter->destroy_func(iter);
		iter->destroy_func = NULL;
	}
	dia_canvas_iter_init(iter);
}

