/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifndef FILEMANAGER_H
#define FILEMANAGER_H

#include <sys/stat.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

struct item {
  char *filename;
  struct stat info;
  int type; /* 0 file 1 folder 2 linkfile 3 linkfolder */
  int mark; /*BOOL*/
  struct item *nextitem;
  struct item *subtree;
  int horizontal;
  Window Iconwindow;
  Window Inputonly;
  Pixmap mini;
  Pixmap minis;
  Window Expandbutton;
  Window Connectline;
  Window ExpandlineV;
  Window ExpandlineH;
  Window Switchbutton;
};

struct item *GetDirectory(char *filepath);

void GetLinkNameWithoutLast(char **text);

void GetLinkName(char **text);

int CopyFile(char *filename,char *goal,char *subfolder,int move);

int FileExist(char *filename);

int CreateProgramLink(char *programname);

int CreateFolder(char *foldername);

int CreateFile(char *filename);

int LinkFile(char *filename,char *subfolder);

int EraseFile(char *filename);

#endif
