#! /bin/bash

TEXTDOMAIN=devscripts
PROGNAME=`basename $0`
PKG_VERSION=@VERSION@

usage () {
    echo \
$"Usage: $PROGNAME [--help|--version]
  Clean all debian build trees under current directory and remove all
  .deb, .changes and .dsc files as well."
}

version () {
    echo \
$"This is $PROGNAME, from the Debian devscripts package, version $PKG_VERSION
This code is copyright 1999 by Julian Gilbey, all rights reserved.
Original code by Christoph Lameter.
This program comes with ABSOLUTELY NO WARRANTY.
You are free to redistribute this code under the terms of the
GNU General Public License, version 2 or later."
}

if [ $# -gt 0 ]
then
    if [ "$1" = --help ]; then usage; exit 0; fi
    if [ "$1" = --version ]; then version; exit 0; fi
    echo $"Usage: $progname [--help|--version]" >&2
    exit 1
fi

# Script to clean up debian directories
for i in `find . -type d -name "debian"`; do
	DIR=${i%/debian}
	echo $DIR
	cd $DIR
	# Clean up the source package
	debuild clean
	cd ..
	# Clean up the package related files
	rm -f *.dsc *.changes *.deb
done
