# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch-contacts.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Nicola Larosa <nicola.larosa@canonical.com>

"""Tests for the ContactDocument class"""

import testtools

from desktopcouch.contacts import record as contact_mod


class TestContactRecord(testtools.TestCase):
    """Test the Contact Record object."""

    def test_contact_record(self):
        """Test that we get the correct record type."""
        contact = contact_mod.Contact()
        self.assertEqual(contact.record_type, contact_mod.CONTACT_RECORD_TYPE)
        for field_name in contact_mod.SINGLE_FIELDS:
            setattr(contact, field_name, field_name)
            self.assertEqual(getattr(contact, field_name), field_name)
            # direct access to internal representation
            self.assertEqual(contact._data[field_name], field_name)
        for field_name in contact_mod.LIST_FIELDS:
            setattr(contact, field_name, [field_name])
            self.assertEqual(getattr(contact, field_name), [field_name])
            # direct access to internal representation
            self.assert_(field_name in contact._data[field_name].values())
        # transversal check
        all_keys = set(contact_mod.ALL_FIELDS)
        all_keys.add('record_type')
        self.assertEqual(set(contact.keys()), all_keys)
