/* playback.c
 * Midi playback for a specific portion of
 * a score
 *
 * (c) 2000, 2001 Adam Tee
 */


#include "datastructures.h"
#include "exportmudela.h"
#include "exportmidi.h"
#include "staffops.h"
#include "scoreops.h"
#include "dialogs.h"
#include "prefops.h"
#include "utils.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifndef G_OS_WIN32
# include <wait.h>
#endif
#include <errno.h>



void
playback (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  static GString *filename = NULL;
  static GString *passtosystem;
  pid_t pid;
  struct scoreinfo *si = callback_data;

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoplayback");
      passtosystem = g_string_new (NULL);
    }

#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      /*
       * Fork failed to create a process :
       */
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;

    }
  else if (pid == 0)
    {
      int status = 0;	    
      if (si->prefs->playbackoutput)
	{
	  exportmidi (filename->str, si, si->start, si->end);
	  fflush (0);
	}
      else
	{
	  /*
	   * This is the child process, which exports the mudela, invokes
	   * lilypond, then invokes the midi player
	   */
	  exportmudela (filename->str, si, si->start, si->end);

	  /* Invoke lilypond */

	  g_string_assign (passtosystem, si->prefs->lilypath->str);
	  g_string_append (passtosystem, " -o ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, " -m ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, ".ly");
	  status = system (passtosystem->str);
	}

      /* Invoke the midi player */
      if(!status) {
       g_string_assign (passtosystem, si->prefs->midiplayer->str);
       g_string_append (passtosystem, " ");
       g_string_append (passtosystem, filename->str);
       g_string_append (passtosystem, ".midi");
       system (passtosystem->str);
      }

      _exit (0);
    }
  /* Otherwise, this is the parent process, in which case we simply
   * want to return the user to his or her regularly scheduled
   * music-making */
}
