/**
 * Regular expression compiler and Discrete Finite Automaton
 * simulator.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdio.h>
#include "grammar.h"
#include "scan.h"
#include "util.h"


/** Name of this program. */
const char* program = "lexan";


/** Compiles regular expressions, and simulates the resulting DFA. */
int
main( int argc, const char* argv[])
{
	int i;
	Grammar grammar;
	const char* file_name = argv[1];
	FILE* file = fopen( file_name, "r");
	assume( file != NULL, file_name);
	read_grammar( &grammar, file);
	for( i = 2; i < argc; i++) {
		file_name = argv[i];
		file = fopen( file_name, "r");
		assume( file != NULL, file_name);
		scan( &grammar, file);
	}
	return 0;
}
