/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */

package com.db4odoc.aliases;

import java.io.File;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;

/**
 * This example shows how to use the same db4o database between 
 * Java and .NET application. Pilot objects are originally saved in Java,
 * then they are read and modified in .NET application and read again 
 * in Java
 *
 */
public class InterLanguageExample {

	private static final String DB4O_FILE_NAME = "reference.db4o";
	
	public static void main(String[] args) {
		//saveObjects();
		// use .NET version to retrieve and modify the objects 
		// and read from Java again. Note, as the objects were set
		// originally in Java, you do not need to use alias.
		readObjects();
	}
	// end main

	private static void saveObjects(){
		new File(DB4O_FILE_NAME ).delete();
		ObjectContainer container = Db4o.openFile(DB4O_FILE_NAME);
		try {
			Pilot pilot = new Pilot("David Barrichello",99);
			container.set(pilot);
			pilot = new Pilot("Michael Schumacher",100);
			container.set(pilot);
		} finally {
			container.close();
		}
	}
	// end saveObjects
	
	private static void readObjects(){
		ObjectContainer container = Db4o.openFile(DB4O_FILE_NAME);
		try {
			ObjectSet result = container.get(new Pilot(null, 0));
			listResult(result);
		} finally {
			container.close();
		}
	}
	// end readObjects
	
	private static void listResult(ObjectSet result) {
        System.out.println(result.size());
        while(result.hasNext()) {
            System.out.println(result.next());
        }
    }
    // end listResult
}
