' Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com 


Imports System
Imports System.IO
Imports System.Collections.Generic

Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config

'*
' * This example shows how to use the same db4o database between 
' * Java and .NET application. Pilot objects are originally saved in .NET,
' * then they are read and modified in Java application and read again 
' * in .NET
' *
' 


Namespace Db4objects.Db4odoc.Aliases

    Public Class InterLanguageExample2

        Private Const Db4oFileName As String = "reference.db4o"

        Public Shared Sub Main(ByVal args As String())
            'SaveObjects()
            ' use Java version to retrieve and modify the objects 
            ' and read from .NET again. Note, as the objects were set
            ' originally in .NET, you do not need to use alias.
            ReadObjects()
        End Sub
        ' end Main

        Private Shared Sub SaveObjects()
            File.Delete(Db4oFileName)
            Dim container As IObjectContainer = Db4oFactory.OpenFile(Db4oFileName)
            Try
                Dim pilot As New Pilot("David Barrichello", 99)
                container.[Set](pilot)
                pilot = New Pilot("Michael Schumacher", 100)
                container.[Set](pilot)
            Finally
                container.Close()
            End Try
        End Sub
        ' end SaveObjects

        Private Shared Sub ReadObjects()
            Dim container As IObjectContainer = Db4oFactory.OpenFile(Db4oFileName)
            Try
                Dim result As IList(Of Pilot) = container.Query(Of Pilot)()
                ListResult(result)
            Finally
                container.Close()
            End Try
        End Sub
        ' end ReadObjects 

        Private Shared Sub ListResult(Of T)(ByVal result As IList(Of T))
            Console.WriteLine(result.Count)
            For i As Integer = 0 To result.Count - 1
                Console.WriteLine(result(i))
            Next
        End Sub
        ' end ListResult
    End Class
End Namespace