/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o
{
	/// <summary>
	/// tracks the version of the last replication between
	/// two Objectcontainers.
	/// </summary>
	/// <remarks>
	/// tracks the version of the last replication between
	/// two Objectcontainers.
	/// </remarks>
	/// <exclude></exclude>
	/// <persistent></persistent>
	public class ReplicationRecord : Db4objects.Db4o.IInternal4
	{
		public Db4objects.Db4o.Ext.Db4oDatabase _youngerPeer;

		public Db4objects.Db4o.Ext.Db4oDatabase _olderPeer;

		public long _version;

		public ReplicationRecord()
		{
		}

		public ReplicationRecord(Db4objects.Db4o.Ext.Db4oDatabase younger, Db4objects.Db4o.Ext.Db4oDatabase
			 older)
		{
			_youngerPeer = younger;
			_olderPeer = older;
		}

		public virtual void SetVersion(long version)
		{
			_version = version;
		}

		public virtual void Store(Db4objects.Db4o.Internal.ObjectContainerBase stream)
		{
			stream.ShowInternalClasses(true);
			try
			{
				Db4objects.Db4o.Internal.Transaction ta = stream.CheckTransaction(null);
				stream.SetAfterReplication(ta, this, 1, false);
				stream.Commit();
			}
			finally
			{
				stream.ShowInternalClasses(false);
			}
		}

		public static Db4objects.Db4o.ReplicationRecord BeginReplication(Db4objects.Db4o.Internal.Transaction
			 transA, Db4objects.Db4o.Internal.Transaction transB)
		{
			Db4objects.Db4o.Internal.ObjectContainerBase peerA = transA.Stream();
			Db4objects.Db4o.Internal.ObjectContainerBase peerB = transB.Stream();
			Db4objects.Db4o.Ext.Db4oDatabase dbA = peerA.Identity();
			Db4objects.Db4o.Ext.Db4oDatabase dbB = peerB.Identity();
			dbB.Bind(transA);
			dbA.Bind(transB);
			Db4objects.Db4o.Ext.Db4oDatabase younger = null;
			Db4objects.Db4o.Ext.Db4oDatabase older = null;
			if (dbA.IsOlderThan(dbB))
			{
				younger = dbB;
				older = dbA;
			}
			else
			{
				younger = dbA;
				older = dbB;
			}
			Db4objects.Db4o.ReplicationRecord rrA = QueryForReplicationRecord(peerA, younger, 
				older);
			Db4objects.Db4o.ReplicationRecord rrB = QueryForReplicationRecord(peerB, younger, 
				older);
			if (rrA == null)
			{
				if (rrB == null)
				{
					return new Db4objects.Db4o.ReplicationRecord(younger, older);
				}
				rrB.Store(peerA);
				return rrB;
			}
			if (rrB == null)
			{
				rrA.Store(peerB);
				return rrA;
			}
			if (rrA != rrB)
			{
				peerB.ShowInternalClasses(true);
				try
				{
					int id = peerB.GetID1(rrB);
					peerB.Bind1(transB, rrA, id);
				}
				finally
				{
					peerB.ShowInternalClasses(false);
				}
			}
			return rrA;
		}

		public static Db4objects.Db4o.ReplicationRecord QueryForReplicationRecord(Db4objects.Db4o.Internal.ObjectContainerBase
			 stream, Db4objects.Db4o.Ext.Db4oDatabase younger, Db4objects.Db4o.Ext.Db4oDatabase
			 older)
		{
			stream.ShowInternalClasses(true);
			try
			{
				Db4objects.Db4o.Query.IQuery q = stream.Query();
				q.Constrain(Db4objects.Db4o.Internal.Const4.CLASS_REPLICATIONRECORD);
				q.Descend("_youngerPeer").Constrain(younger).Identity();
				q.Descend("_olderPeer").Constrain(older).Identity();
				Db4objects.Db4o.IObjectSet objectSet = q.Execute();
				return objectSet.HasNext() ? (Db4objects.Db4o.ReplicationRecord)objectSet.Next() : 
					null;
			}
			finally
			{
				stream.ShowInternalClasses(false);
			}
		}
	}
}
