/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Nativequery.Expr.Cmp
{
	public class ArithmeticExpression : Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand
	{
		private Db4objects.Db4o.Nativequery.Expr.Cmp.ArithmeticOperator _op;

		private Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand _left;

		private Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand _right;

		public ArithmeticExpression(Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand
			 left, Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand right, Db4objects.Db4o.Nativequery.Expr.Cmp.ArithmeticOperator
			 op)
		{
			this._op = op;
			this._left = left;
			this._right = right;
		}

		public virtual Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand Left()
		{
			return _left;
		}

		public virtual Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand Right()
		{
			return _right;
		}

		public virtual Db4objects.Db4o.Nativequery.Expr.Cmp.ArithmeticOperator Op()
		{
			return _op;
		}

		public override string ToString()
		{
			return "(" + _left + _op + _right + ")";
		}

		public override bool Equals(object obj)
		{
			if (this == obj)
			{
				return true;
			}
			if (obj == null || obj.GetType() != GetType())
			{
				return false;
			}
			Db4objects.Db4o.Nativequery.Expr.Cmp.ArithmeticExpression casted = (Db4objects.Db4o.Nativequery.Expr.Cmp.ArithmeticExpression
				)obj;
			return _left.Equals(casted._left) && _right.Equals(casted._right) && _op.Equals(casted
				._op);
		}

		public override int GetHashCode()
		{
			int hc = _left.GetHashCode();
			hc *= 29 + _right.GetHashCode();
			hc *= 29 + _op.GetHashCode();
			return hc;
		}

		public virtual void Accept(Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperandVisitor
			 visitor)
		{
			visitor.Visit(this);
		}
	}
}
