/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Handlers
{
	/// <exclude></exclude>
	public sealed class DoubleHandler : Db4objects.Db4o.Internal.Handlers.LongHandler
	{
		private static readonly double DEFAULT_VALUE = System.Convert.ToDouble(0);

		public DoubleHandler(Db4objects.Db4o.Internal.ObjectContainerBase stream) : base(
			stream)
		{
		}

		public override object Coerce(Db4objects.Db4o.Reflect.IReflectClass claxx, object
			 obj)
		{
			return Db4objects.Db4o.Foundation.Coercion4.ToDouble(obj);
		}

		public override object DefaultValue()
		{
			return DEFAULT_VALUE;
		}

		public override int GetID()
		{
			return 5;
		}

		protected override System.Type PrimitiveJavaClass()
		{
			return typeof(double);
		}

		public override object PrimitiveNull()
		{
			return DEFAULT_VALUE;
		}

		public override object Read(Db4objects.Db4o.Internal.Marshall.MarshallerFamily mf
			, Db4objects.Db4o.Internal.StatefulBuffer buffer, bool redirect)
		{
			return mf._primitive.ReadDouble(buffer);
		}

		internal override object Read1(Db4objects.Db4o.Internal.Buffer buffer)
		{
			return PrimitiveMarshaller().ReadDouble(buffer);
		}

		public override void Write(object a_object, Db4objects.Db4o.Internal.Buffer a_bytes
			)
		{
			a_bytes.WriteLong(Db4objects.Db4o.Internal.Platform4.DoubleToLong(((double)a_object
				)));
		}

		private double i_compareToDouble;

		private double Dval(object obj)
		{
			return ((double)obj);
		}

		internal override void PrepareComparison1(object obj)
		{
			i_compareToDouble = Dval(obj);
		}

		public override object Current1()
		{
			return i_compareToDouble;
		}

		internal override bool IsEqual1(object obj)
		{
			return obj is double && Dval(obj) == i_compareToDouble;
		}

		internal override bool IsGreater1(object obj)
		{
			return obj is double && Dval(obj) > i_compareToDouble;
		}

		internal override bool IsSmaller1(object obj)
		{
			return obj is double && Dval(obj) < i_compareToDouble;
		}
	}
}
