/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Foundation
{
	/// <exclude></exclude>
	public class HashtableIntEntry : Db4objects.Db4o.Foundation.IDeepClone
	{
		internal int i_key;

		internal object i_object;

		internal Db4objects.Db4o.Foundation.HashtableIntEntry i_next;

		internal HashtableIntEntry(int a_hash, object a_object)
		{
			i_key = a_hash;
			i_object = a_object;
		}

		protected HashtableIntEntry()
		{
		}

		public virtual void AcceptKeyVisitor(Db4objects.Db4o.Foundation.IVisitor4 visitor
			)
		{
			visitor.Visit(i_key);
		}

		public virtual object DeepClone(object obj)
		{
			return DeepCloneInternal(new Db4objects.Db4o.Foundation.HashtableIntEntry(), obj);
		}

		public virtual bool SameKeyAs(Db4objects.Db4o.Foundation.HashtableIntEntry other)
		{
			return i_key == other.i_key;
		}

		protected virtual Db4objects.Db4o.Foundation.HashtableIntEntry DeepCloneInternal(
			Db4objects.Db4o.Foundation.HashtableIntEntry entry, object obj)
		{
			entry.i_key = i_key;
			entry.i_next = i_next;
			if (i_object is Db4objects.Db4o.Foundation.IDeepClone)
			{
				entry.i_object = ((Db4objects.Db4o.Foundation.IDeepClone)i_object).DeepClone(obj);
			}
			else
			{
				entry.i_object = i_object;
			}
			if (i_next != null)
			{
				entry.i_next = (Db4objects.Db4o.Foundation.HashtableIntEntry)i_next.DeepClone(obj
					);
			}
			return entry;
		}
	}
}
