/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Events
{
	public delegate void QueryEventHandler(object sender, Db4objects.Db4o.Events.QueryEventArgs
		 args);

	public delegate void CancellableObjectEventHandler(object sender, Db4objects.Db4o.Events.CancellableObjectEventArgs
		 args);

	public delegate void ObjectEventHandler(object sender, Db4objects.Db4o.Events.ObjectEventArgs
		 args);

	public delegate void ClassEventHandler(object sender, Db4objects.Db4o.Events.ClassEventArgs
		 args);

	/// <summary>
	/// Provides a way to register event handlers for specific
	/// <see cref="ObjectContainer">ObjectContainer</see>
	/// events.
	/// </summary>
	/// <seealso cref="Db4objects.Db4o.Events.EventRegistryFactory">Db4objects.Db4o.Events.EventRegistryFactory
	/// 	</seealso>
	public interface IEventRegistry
	{
		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.QueryEventArgs">Db4objects.Db4o.Events.QueryEventArgs
		/// 	</see>
		/// .
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.QueryEventHandler QueryStarted;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.QueryEventArgs">Db4objects.Db4o.Events.QueryEventArgs
		/// 	</see>
		/// .
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.QueryEventHandler QueryFinished;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.CancellableObjectEventArgs">Db4objects.Db4o.Events.CancellableObjectEventArgs
		/// 	</see>
		/// .
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.CancellableObjectEventHandler Creating;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.CancellableObjectEventArgs">Db4objects.Db4o.Events.CancellableObjectEventArgs
		/// 	</see>
		/// .
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.CancellableObjectEventHandler Activating;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.CancellableObjectEventArgs">Db4objects.Db4o.Events.CancellableObjectEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.CancellableObjectEventHandler Updating;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.CancellableObjectEventArgs">Db4objects.Db4o.Events.CancellableObjectEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.CancellableObjectEventHandler Deleting;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.CancellableObjectEventArgs">Db4objects.Db4o.Events.CancellableObjectEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.CancellableObjectEventHandler Deactivating;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.ObjectEventArgs">Db4objects.Db4o.Events.ObjectEventArgs
		/// 	</see>
		/// .
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.ObjectEventHandler Activated;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.ObjectEventArgs">Db4objects.Db4o.Events.ObjectEventArgs
		/// 	</see>
		/// .
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.ObjectEventHandler Created;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.ObjectEventArgs">Db4objects.Db4o.Events.ObjectEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.ObjectEventHandler Updated;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.ObjectEventArgs">Db4objects.Db4o.Events.ObjectEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.ObjectEventHandler Deleted;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.ObjectEventArgs">Db4objects.Db4o.Events.ObjectEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.ObjectEventHandler Deactivated;

		/// <summary>
		/// Receives
		/// <see cref="Db4objects.Db4o.Events.ClassEventArgs">Db4objects.Db4o.Events.ClassEventArgs
		/// 	</see>
		/// </summary>
		/// <returns></returns>
		event Db4objects.Db4o.Events.ClassEventHandler ClassRegistered;
	}
}
