Imports System
Imports System.Collections.Generic
Imports System.IO
Imports Db4objects.Db4o
Imports Db4objects.Db4odoc.ReportsExample.Persistent

Namespace Modules

    Class Db4oManager
        Public Const DbFileName As String = "..//..//Data//formula1.db"
        Public Shared _db As IObjectContainer

        Private Sub New()
        End Sub

        Public Shared Sub FillUpDB()
            Dim pilot As Pilot = New Pilot("Michael Schumacher", 100)
            Db.Set(pilot)
            pilot = New Pilot("David Barichello", 95)
            Db.Set(pilot)
            pilot = New Pilot("Kimi Raikkonen", 100)
            Db.Set(pilot)
        End Sub
        ' end FillUpDB

        Public Shared Function GetAllPilots() As IList
            Dim result As IList = Db.Query(GetType(Pilot))
            Return result
        End Function
        ' end GetAllPilots

        Public Shared Sub StoreObject(ByVal obj As Object)
            Db.Set(obj)
        End Sub
        ' end StoreObject

        Public Shared Function Db() As IObjectContainer
            If _db Is Nothing Then
                _db = Db4oFactory.OpenFile(DbFileName)
            End If
            Return _db
        End Function
        ' end Db

        Public Shared Sub CloseDb()
            If Not (_db Is Nothing) Then
                _db.Close()
            End If
        End Sub
        ' end CloseDb

    End Class
End Namespace