/* 
** Default values for constants.
 */

/*
 *  This file is part of davfs2.
 *
 *  davfs2 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  davfs2 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with davfs2; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef __DEFAULTS_H__
#define __DEFAULTS_H__


/* Misc. */
/*=======*/

#define DAV_HOME "http://dav.sourceforge.net"

/* File system type to be used with 'mount -t' and fstab. */
#define DAV_FS_TYPE "davfs"

/* Mount options set by mount program in case of mounting by an
   ordinary user. */
#define DAV_USER_MOPTS (MS_MGC_VAL | MS_NOSUID | MS_NOEXEC | MS_NODEV)

/* This mount options will allways be set by davfs2. Different values from
   command line and even fstab will be silently ignored. */
#define DAV_MOPTS (MS_MGC_VAL | MS_NOSUID | MS_NODEV)

/* Ordinary users must be member of this group to be able to mount.
   May be overridden by system config file. */
#define DAV_GROUP "users"

/* XML namespace for the cache index file. */
#define DAV_XML_NS "http://dav.sf.net/"


/* Directories and Files */
/*=======================*/

/* The device directory. */
#define DAV_DEV_DIR "/dev"

/* The file davfs reads mtab entries from. If not available it will
   use _PATH_MOUNTED. */
#define DAV_MOUNTS "/proc/mounts"

/* The directory where the cache files will be stored, when mounted by root.
   May be overridden by system config file. */
#define DAV_SYS_CACHE "/var/cache/" PACKAGE_TARNAME

/* The directory where the pid-files will be placed. */
#define DAV_SYS_RUN "/var/run/" PROGRAM_NAME

/* Directory holding user config files and cache directory. */
#define DAV_USER_DIR "~/." PACKAGE_TARNAME

/* User configuration file; relative to DAV_USER_DIR.
   May be overridden by command line or fstab. */
#define DAV_USER_CONF PACKAGE_TARNAME ".conf"

/* User file holding credentials; relative to DAV_USER_DIR. */
#define DAV_USER_SECRETS "secrets"

/* The directory where the cache files will be stored, when mounted by
   a non root users; relative to DAV_USER_DIR.
   May be overridden by user config file. */
#define DAV_USER_CACHE "cache"

/* The name of index files. */
#define DAV_INDEX "index"

/* Name of the directory within the davfs2 filesystem that holds local
   backup files.
   May be overridden by system config file and user config file. */
#define DAV_BACKUP_DIR "lost+found"

/* Buffer size for reading the XML index files of persistent cache. */
#define DAV_XML_BUF_SIZE 16 * 1024


/* Cache Optimization */
/*====================*/

/* Cache size in MiByte.
   May be overridden by system config file and user config file.
   (1 MiByte = 1,048,576 Byte; Mi = Mebi = Mega Binary according to IEC) */
#define DAV_CACHE_SIZE 50

/* Size of the hash table to store nodes. Should be a power of 2.
   May be overridden by system config file and user config file. */
#define DAV_TABLE_SIZE 1024

/* The time in seconds to wait before the idle function is called, when
   there are no upcalls from kernel. The idle function will mainly put
   back files to the server.
   May be overridden by system config file and user config file. */
#define DAV_IDLE_TIME 10

/* How long in seconds a cached directory is valid. After this time
   a new PROPFIND request for this directory must be performed.
   May be overridden by system config file and user config file. */
#define DAV_EXPIRE 300

/* Wait at least that many seconds from last file access until a new
   GET If-Modified request is send to the server. If set to 0 a request
   will be send every time the file is opened. But some applications do
   open and close calls in short sequence that cause - mostly - unnecessary
   traffic.
   May be overridden by system config file and user config file. */
#define DAV_GET_WAIT 1

/* Default retry time after a PROPFIND request failed. When the request fails
   again, the retry time will subsequently be increased up to DAV_MAX_RETRY.
   May be overridden by system config file and user config file. */
#define DAV_RETRY 30

/* Maximum retry time after a PROPFIND request failed.
   May be overridden by system config file and user config file. */
#define DAV_MAX_RETRY 300

/* Preferred live time of locks in seconds, before they have to be refreshed.
   May be overridden by system config file and user config file. */
#define DAV_LOCK_TIMEOUT 1800

/* How many seconds before a lock expires it should be refreshed.
   May be overridden by system config file and user config file. */
#define DAV_LOCK_REFRESH 60


/* HTTP */
/*======*/

/* The default proxy port.
   May be overridden by system config file, user config file or environment
   variable. */
#define DAV_DEFAULT_PROXY_PORT 8080

/* Whether to use a proxy if one is specified.
   May be overridden by command line or fstab. */
#define DAV_USE_PROXY 1

/* Whether to ask user for credentials if not given.
   May be overridden by command line or fstab. */
#define DAV_ASKAUTH 1

/* Use the value of property displayname, if present.
   May be overridden by system config file and user config file. */
#define DAV_DISPLAYNAME 1

/* Whether to use locks.
   May be overridden by command line or fstab. */
#define DAV_LOCKS 1

/* Timeout in seconds used when reading from a socket.
   May be overridden by system config file and user config file. */
#define DAV_READ_TIMEOUT 30


#endif
