#!/usr/bin/env python
#
# Script that will move Insight testing results from /ftp/incoming to the 
# appropriate location for dashboard summarization.  
#
###

import cgi
import cgitb; cgitb.enable()

import re
import sys
import os
import traceback

def unencode(match):
  return "%c" % (int("0x%s" % match.group(1)))


def Trigger(destination, project, dropLocation = "/dart_incoming"):
  print "Content-type: text/plain"
  print ""

  form = cgi.FieldStorage()
  xmlfile = ""
  if form.has_key("xmlfile"):
    xmlfile = form["xmlfile"].value
  
  if not xmlfile:
    print "Sumbission file not specified"
    sys.exit(1)
  
  xmlfile = re.sub("\%(..)", unencode, xmlfile)
  if re.match("[^A-Za-z0-9_+.-]", xmlfile):
    print "Bad XML file name specified"
    sys.exit(1)
  
  fullPathToIncomingXMLFile = os.path.join(dropLocation, xmlfile)
  if not os.path.exists(fullPathToIncomingXMLFile):
    print "Cannot found file: %s" % xmlfile
    sys.exit(1)
  
  # file exists, so lets move it
  # first, translate the xml filename to a directory path
  xmlfile = re.sub("___", "/", xmlfile)
  
  # for security reasons, disallow any file with ".." in the user 
  # specified path to keep people from storing files just anywhere in
  # the host directory structure
  if re.match("\.\.", xmlfile):
    print "Bad XML file name specified"
    sys.exit(1)
  
  # construct destination path and filename
  fullPathToDestinationXMLFile = os.path.join(destination, xmlfile)
  
  # make directory
  dirname = os.path.dirname(fullPathToDestinationXMLFile)
  if not os.path.exists(dirname):
    try:
      os.makedirs(dirname)
    except:
      print "Problem creating directory: %s" % dirname
      sys.exit(1)
  
  # now copy the file to destination
  try:
    print "Rename file: %s to %s" % (fullPathToIncomingXMLFile, fullPathToDestinationXMLFile)
    os.rename(fullPathToIncomingXMLFile, fullPathToDestinationXMLFile)
  except:
    print "Problem triggering file: %s" % xmlfile
    print "Rename: %s to %s" % (fullPathToIncomingXMLFile, fullPathToDestinationXMLFile)
    print "Unexpected error:", sys.exc_info()
    traceback.print_exc(file=sys.stdout)
    sys.exit(1)

  if project == "CMake":
    try:
      import xmlrpclib
      
      server = xmlrpclib.ServerProxy("http://www.na-mic.org:8081/%s/Command/" % project)
      print server
      
      try:
        fp = open(fullPathToDestinationXMLFile)
        bin = xmlrpclib.Binary(fp.read())
        print "Server responded: [%s]" % server.Submit.put(bin)
      except Exception, v:
        print "ERROR", v
    except:
      print "Problem submitting XML-RPC for the file: %s" % xmlfile
      
  
  if fullPathToDestinationXMLFile[-3:] == ".gz":
    import gzip
    import shutil
    resname = fullPathToDestinationXMLFile[:-3]
    try:
      fp = gzip.open(fullPathToDestinationXMLFile)
      fr = open(resname, "w")
      shutil.copyfileobj(fp, fr)
      fp.close()
      fr.close()
      os.remove(fullPathToDestinationXMLFile)
    except:
      try:
        os.remove(resname)
      except:
        pass
      print "Problem uncompressing submission file"
      sys.exit(1)
  
  print "%s submission successful." % xmlfile
