/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class SaxonImportQuery
extends StyleElement {
    private String href;
    private String moduleURI;

    public void importModule() throws TransformerConfigurationException {
        this.prepareAttributes();
        this.loadLibraryModule();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        if (this.href != null || this.moduleURI != null) {
            return;
        }
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "href") {
                this.href = attributeCollection.getValue(n).trim();
            } else if (string == "namespace") {
                this.moduleURI = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
                this.moduleURI = "";
            }
            ++n;
        }
        if (this.href == null && this.moduleURI == null) {
            this.compileError("At least one of href or namespace must be specified");
            this.moduleURI = "";
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel();
    }

    private void loadLibraryModule() throws TransformerConfigurationException {
        if (this.href == null && this.moduleURI == null) {
            return;
        }
        try {
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            int n = xSLStyleSheet.allocateSlotNumber();
            StaticQueryContext staticQueryContext = this.loadModule(this.moduleURI, this.href, n);
            int n2 = 0;
            while (n2 < staticQueryContext.getNumberOfGlobalVariables()) {
                xSLStyleSheet.allocateSlotNumber();
                ++n2;
            }
            xSLStyleSheet.allocateLocalSlots(staticQueryContext.getNumberOfLocalVariables());
            short s = staticQueryContext.getModuleNamespaceCode();
            NamePool namePool = this.getTargetNamePool();
            Iterator iterator = staticQueryContext.getFunctionDefinitions();
            while (iterator.hasNext()) {
                XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
                if (namePool.getURICode(xQueryFunction.getFunctionFingerprint()) != s) continue;
                xSLStyleSheet.declareXQueryFunction(xQueryFunction);
            }
        }
        catch (TransformerException transformerException) {
            this.compileError(transformerException);
        }
    }

    private StaticQueryContext loadModule(String string, String string2, int n) throws XPathException {
        URL uRL;
        Configuration configuration = this.getPreparedStyleSheet().getConfiguration();
        StaticQueryContext staticQueryContext = configuration.getQueryLibraryModule(string);
        if (staticQueryContext != null) {
            return staticQueryContext;
        }
        if (string2 == null) {
            throw new XPathException.Static("saxon:import-query must either specify a known namespace or a location");
        }
        String string3 = this.getBaseURI();
        if (string3 == null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException.Static("Cannot resolve absolute URI", malformedURLException);
            }
        }
        try {
            uRL = new URL(new URL(string3), string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathException.Static("Cannot resolve relative URI", malformedURLException);
        }
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[2048];
            int n2 = 0;
            while ((n2 = bufferedReader.read(cArray, 0, 2048)) >= 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            StaticQueryContext staticQueryContext2 = new StaticQueryContext(configuration);
            staticQueryContext2.setBaseURI(uRL.toString());
            QueryParser queryParser = new QueryParser();
            queryParser.parseLibraryModule(stringBuffer.toString(), staticQueryContext2, n);
            if (staticQueryContext2.getModuleNamespace() == null) {
                throw new XPathException.Static("Imported module must be a library module");
            }
            if (!staticQueryContext2.getModuleNamespace().equals(string)) {
                throw new XPathException.Static("Imported module's namespace does not match requested namespace");
            }
            configuration.addQueryLibraryModule(staticQueryContext2);
            return staticQueryContext2;
        }
        catch (IOException iOException) {
            throw new XPathException.Dynamic(iOException);
        }
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        return null;
    }
}

