/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.type.ItemType;

public class Message
extends Instruction {
    private Expression terminate;
    private Expression select;

    public Message(Expression expression, Expression expression2) {
        this.terminate = expression2;
        this.select = expression;
    }

    public String getInstructionName() {
        return "message";
    }

    public ItemType getItemType() {
        return NoNodeTest.getInstance();
    }

    public int getCardinality() {
        return 256;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Object object;
        Controller controller = xPathContext.getController();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            emitter = controller.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter(new OutputStreamWriter(System.err));
        }
        TreeReceiver treeReceiver = new TreeReceiver(emitter);
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        emitter.setOutputProperties(properties);
        controller.changeOutputDestination(properties, treeReceiver, false, 3, null);
        if (this.select != null) {
            Item item;
            object = this.select.iterate(xPathContext);
            while ((item = object.next()) != null) {
                treeReceiver.append(item);
            }
        }
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        if (this.terminate != null && !((String)(object = this.terminate.evaluateAsString(xPathContext))).equals("no")) {
            if (((String)object).equals("yes")) {
                throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber());
            }
            throw new TransformerException("The terminate attribute of xsl:message must be 'yes' or 'no'");
        }
        return null;
    }
}

