/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;

public class ForEach
extends Instruction {
    private Expression select = null;

    public ForEach(Expression expression) {
        this.select = expression;
    }

    public String getInstructionName() {
        return "for-each";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceIterator sequenceIterator = controller.getCurrentIterator();
        SequenceIterator sequenceIterator2 = this.select.iterate(xPathContext);
        Template template = controller.getCurrentTemplate();
        controller.setCurrentTemplate(null);
        controller.setCurrentIterator(sequenceIterator2);
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(sequenceIterator2);
        if (controller.isTracing()) {
            Item item;
            TraceListener traceListener = controller.getTraceListener();
            while ((item = sequenceIterator2.next()) != null) {
                traceListener.startCurrentItem(item);
                this.processChildren(xPathContext2);
                traceListener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = sequenceIterator2.next()) != null) {
                this.processChildren(xPathContext2);
            }
        }
        controller.setCurrentIterator(sequenceIterator);
        controller.setCurrentTemplate(template);
        return null;
    }
}

