@ECHO OFF

REM ------------------------------------------------------------------
REM Dash batch
REM S. Barre (Time-stamp: <2001-10-26 17:16:06 barre>
REM 
REM Usage:
REM    dash [s|b|e] [n]
REM
REM Run tclsh83 on DashboardManager.tcl (provided that DART_ROOT is set)
REM
REM    [s|b|e|n] => s: DashboardStart
REM                 b: Start Build Test Submit
REM                 e: DashboardEnd
REM                  : DashboardStart Start Build Test Submit DashboardEnd
REM
REM Default model is Experimental, unless option 'n' (Nightly)
REM ------------------------------------------------------------------

SET P1=%1
SET P2=%2

SET MNG=%DART_ROOT%\Source\Client\DashboardManager.tcl
SET CFG=DartConfiguration.tcl

SET START=DashboardStart
SET BUILD=Start Build Test Submit
SET END=DashboardEnd

IF /I "%P1%" == "n" (SET MOD=Nightly&& SET P1=) ELSE (IF /I "%P2%" == "n" (SET MOD=Nightly) ELSE (SET MOD=Experimental))

IF /I "%P1%" == "s" (tclsh83 %MNG% %CFG% %MOD% %START%) ELSE (IF /I "%P1%" == "b" (tclsh83 %MNG% %CFG% %MOD% %BUILD%) ELSE (IF /I "%P1%" == "e" (tclsh83 %MNG% %CFG% %MOD% %END%) ELSE (tclsh83 %MNG% %CFG% %MOD% %START% %BUILD% %END%)))
