/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient DTMIterator m_nodeSet;

    FilterExprWalker(WalkingIterator walkingIterator) {
        super(walkingIterator, 20);
    }

    public short acceptNode(int n) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker filterExprWalker = (FilterExprWalker)super.clone();
        if (this.m_nodeSet != null) {
            filterExprWalker.m_nodeSet = (DTMIterator)this.m_nodeSet.clone();
        }
        return filterExprWalker;
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        this.m_expr.fixupVariables(vector, n);
    }

    public int getAxis() {
        return this.m_nodeSet.getAxis();
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.m_nodeSet.getLength();
    }

    public int getNextNode() {
        if (this.m_nodeSet != null) {
            return this.m_nodeSet.nextNode();
        }
        return -1;
    }

    public void init(Compiler compiler, int n, int n2) throws TransformerException {
        super.init(compiler, n, n2);
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(n);
                break;
            }
            default: {
                this.m_expr = compiler.compile(n + 2);
            }
        }
    }

    public boolean isDocOrdered() {
        return this.m_nodeSet.isDocOrdered();
    }

    public void setRoot(int n) {
        XPathContext xPathContext = this.m_lpi.getXPathContext();
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        try {
            try {
                xPathContext.pushCurrentNode(n);
                xPathContext.setNamespaceContext(this.m_lpi.getPrefixResolver());
                if (this.m_lpi.getIsTopLevel()) {
                    VariableStack variableStack = this.m_lpi.m_execContext.getVarStack();
                    int n2 = variableStack.getStackFrame();
                    variableStack.setStackFrame(this.m_lpi.m_stackFrame);
                    this.m_nodeSet = this.m_expr.asIterator(xPathContext, n);
                    variableStack.setStackFrame(n2);
                } else {
                    this.m_nodeSet = this.m_expr.asIterator(xPathContext, n);
                }
            }
            catch (TransformerException transformerException) {
                throw new WrappedRuntimeException(transformerException);
            }
            Object var5_7 = null;
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver);
            throw throwable;
        }
        super.setRoot(n);
    }
}

