{-# OPTIONS_GHC -fno-warn-orphans #-}
module Darcs.Patch.V1.Viewing () where

import Prelude ()
import Darcs.Prelude

import Darcs.Patch.Prim ( PrimPatch )
import Darcs.Patch.Show ( ShowPatchBasic(..), ShowPatch(..) )
import Darcs.Patch.Summary ( plainSummary )

import Darcs.Patch.V1.Apply ()
import Darcs.Patch.V1.Core ( RepoPatchV1(..) )
import Darcs.Patch.V1.Show ( showPatch_ )


instance PrimPatch prim => ShowPatchBasic (RepoPatchV1 prim) where
    showPatch = showPatch_

instance PrimPatch prim => ShowPatch (RepoPatchV1 prim) where
    showContextPatch (PP p) = showContextPatch p
    showContextPatch p = return $ showPatch p
    summary = plainSummary
    summaryFL = plainSummary
    thing _ = "change"

