/************************************************************************
 *   IRC - Internet Relay Chat, src/m_scan.c
 *   This file is copyright (C) 2001 Andrew Suffield
 *                                    <asuffield@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "client.h"
#include "ircd.h"
#include "common.h"
#include "numeric.h"
#include "irc_string.h"
#include "send.h"
#include "umodes.h"
#include "m_commands.h"
#include "varparse.h"
#include "channel.h"
#include "umodes.h"

#include <stdlib.h>

var_handler_func m_scan_umodes;

static struct variable_tier scan_parse_tree[] = {
  {"UMODES", 0, NULL, m_scan_umodes},
  {NULL, 0, NULL, NULL}
};

int m_scan(struct Client *cptr, struct Client *sptr, int parc, char *parv[])
{
  if (!HasUmode(sptr,UMODE_EXPERIMENTAL))
    {
      if (SeesOperMessages(sptr))
	sendto_one(sptr,":%s NOTICE %s :You have no X umode", me.name, parv[0]);
      else
	sendto_one(sptr, form_str(ERR_NOPRIVILEGES), me.name, parv[0]);
      return 0;
    }

  return variable_parse(cptr, sptr, parc, parv, scan_parse_tree, "SCAN");
}

int
m_scan_umodes(struct Client *cptr, struct Client *sptr, int parc, char *parv[], char *varparv[])
{
  char *umode_string = parv[2], *c;
  user_modes include_modes, exclude_modes;
  int what = MODE_ADD;
  int mode, badflag = 0;
  int list_users = 1;
  int list_max = 0;
  int allowed = 1;
  int listed_so_far = 0, count = 0;
  char *mask = NULL;
  struct Client *acptr;
  int i;

  if (parc < 3)
    {
      if (!IsServer(sptr))
	sendto_one(sptr, form_str(ERR_NEEDMOREPARAMS),
		   me.name, parv[0], "SCAN UMODES");
      return 0;
    }

  ClearBitfield(include_modes);
  ClearBitfield(exclude_modes);

  for (c = umode_string; *c; c++)
    switch(*c)
      {
      case '+':
	what = MODE_ADD;
	break;
      case '-':
	what = MODE_DEL;
	break;
      default:
	if ((mode = user_modes_from_c_to_bitmask[(unsigned char)*c]))
	  {
	    if (what == MODE_ADD)
	      SetBit(include_modes, mode);
	    else
	      SetBit(exclude_modes, mode);
	  }
	else
	  badflag = 1;
      }

  for (i = 3; i < parc; i++)
    {
      if (!irccmp(parv[i], "no-list"))
	list_users = 0;
      else if (!irccmp(parv[i], "list"))
	list_users = 1;
      else if (!irccmp(parv[i], "allowed"))
	allowed = 1;
      else if (!irccmp(parv[i], "current"))
	allowed = 0;
      else if (i < (parc - 1))
	{
	  if (!irccmp(parv[i], "list-max"))
	    {
	      list_max = atoi(parv[++i]);
	    }
	  else if (!irccmp(parv[i], "mask"))
	    {
	      mask = parv[++i];
	    }
	}
    }

  for (acptr = GlobalClientList; acptr; acptr = acptr->next)
    {
      char *s;
      user_modes working_umodes;

      if (!IsClient(acptr))
	continue;

      if (allowed)
	AndUmodes(working_umodes, acptr->allowed_umodes, include_modes);
      else
	AndUmodes(working_umodes, acptr->umodes, include_modes);

      if (!SameBits(working_umodes, include_modes))
	continue;

      if (allowed)
	AndUmodes(working_umodes, acptr->allowed_umodes, exclude_modes);
      else
	AndUmodes(working_umodes, acptr->umodes, exclude_modes);

      if (AnyBits(working_umodes))
	continue;

      s = make_nick_user_host(acptr->name, acptr->username,
			      acptr->host);

      if (mask && !match(mask, s))
	continue;

      if (list_users && (!list_max || (listed_so_far < list_max)))
	{
	  char buf[BUFSIZE];
	  char *m = buf;
	  int i;
	  *m++ = '+';
	  for (i = 0; user_mode_table[i].letter && (m - buf < BUFSIZE - 4);i++)
	    if (TestBit(allowed ? acptr->allowed_umodes : acptr->umodes, user_mode_table[i].mode))
	      *m++ = user_mode_table[i].letter;
	  *m = '\0';
	  listed_so_far++;
	  sendto_one(sptr, form_str(RPL_MODE),
		     me.name, sptr->name,
		     acptr->name, buf);
	}
      count++;
    }

  {
    char buf[BUFSIZE];
    ircsnprintf(buf, BUFSIZE, "%d users matched", count);
    sendto_one(sptr, form_str(RPL_MESSAGE),
	       me.name, sptr->name, "REPLY-SCAN",
	       buf);
  }

  sendto_one(sptr, form_str(RPL_ENDMODE),
	     me.name, sptr->name, "user");

  return 0;
}
