/***************************************************************************
                          leveldaten.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEVELDATEN_H
#define LEVELDATEN_H

#include "inkompatibel.h"

#include <qcolor.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qimage.h>
#include <qvector.h>

#include "sorte.h"
#include "bilddatei.h"


/***** Konstanten, die irgend was einstellen *****/

/* Gre des Levels */
#define grx 10
#define gry 20

#define platzbild_anzahl 8 // Anzahl der Bildchen der Platz-Animation

#define max_farben_zahl 200 // Max. Anzahl der Farben in einem Level

/* Wofr gibt es wie viele Punkte */
#define punkte_fuer_normales 1
#define punkte_fuer_graues 0
#define punkte_fuer_gras 20
#define punkte_fuer_kettenreaktion 10

/* Pixel pro Schritt: Bonus-Hetzrand-Geschwindigkeit */
#define bonus_geschwindigkeit 16
/* Punkte pro Zeitschritt der Bonus-Animation */
#define punkte_fuer_zeitbonus 5



/***** Konstanten, die einfach nur was bedeuten *****/

#define zufallsgraue_keine -1
#define PlatzAnzahl_undefiniert -1


/* Zur bergabe an laden(), um den Titel-Level zu laden */
#define level_titel -1


/* Fr das Array mSchriftfarbe */
#define schrift_dunkel 0
#define schrift_normal 1
#define schrift_hell 2

/* nachbarschaft_... steht in sorte.h */


class Code;
class Blop;
class DefKnoten;
class ListenKnoten;
class DatenDatei;
class Fehler;


/** (Einziges globales) Objekt enthlt alle Informationen ber
    den aktuellen Level.
    
    Das Parsen der level.descr:
    - Beim Aufruf des constructors von LevelDaten() wird ladLevelConf()
      aufgerufen.
    - ladLevelConf() sucht die richtige Datei und erzeugt ein
      DatenDatei-Objekt
    - Der Constructor davon ffnet die Datei und ruft parse() auf.
    - parse() ruft den bison-Parser auf. Der erzeugt folgendes:
      - Einen Baum aus Knoten: DefKnoten, ListenKnoten, WortKnoten
      - Jeder DefKnoten enthlt noch eine Liste von Codeen (die
        in der level.descr in << >> definiert wurden)
      - Codeen sind auch wieder baumartig
    - Wenn in einem Code ein Name eines anderen Codes vorkommt,
      wird das schon beim Parsen aufgelst, indem in den CodeSpeichern
      der darberliegenden DefKnoten nachgeschaut wird
      
    
    @author Immi
*/


class LevelDaten {
  friend Sorte::Sorte(__String name, int blopart);
	
 public:
  LevelDaten();
  ~LevelDaten();
  
  /** Ld die Levelconf (neu). Wird vom Konstruktor aufgerufen. Und
      vielleicht im Debug-Modus ab und zu... */
  void ladLevelConf();
  
  /** Wird whrend des Parsens (d. h. innerhalb von ladLevelConf() von
      DefKnoten aufgerufen, wenn ein neuer Level gefunden wurde. Fgt
      den Level in die Liste der Level ein. ladLevelConf() kann sich
      danach immernoch entscheiden, ob es die Liste wieder lscht und
      durch die "level=..."-Liste ersetzt. */
  void levelGefunden(__String lna);

  /** fllt alle Daten in diesem Objekt fr Level nr aus; throwt bei Fehler */
  void ladLevel(int nr, int spz);

  /** Fllt das von den Daten aus, was auch ohne Level notwendig ist
      (Punkte-Icons, Schriftfarbe) */
  void ladKeinenLevel();
  
  /** Sollte am Anfang des Levels aufgerufen werden; kmmert sich
      um den Global-Blop */
  void startLevel() const;
  
  /** Sollte einmal pro Spielschritt aufgerufen werden (bevor
      Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich 
      um den Global-Blop */
  void spielSchritt() const;

  /** Liefert zurck, wie viele Level es gibt. */
  int getLevelAnz() const;

  /** Liefert den Namen von Level nr zurck. Liefert "???" bei Fehler. */
  __String getLevelName(int nr) const;

  /** Liefert den internen Namen von Level nr zurck. */
  __String getIntLevelName(int nr) const;

  /** Liefert die Nummer des Levels mit dem angegebenen Namen zurck,
      oder 0, wenn der Level nicht existiert. */
  int getLevelNr(__String na) const;

 protected:
 
  /** Setzt mSchriftFarbe[...]. Berechnet also insbesondere die dunkle
      und die helle Farbe. */
  void setSchriftFarbe(QColor f);
 
 
 /** Das Objekt, mit dem man auf die Datei zugreift. Hier steht nur ein
     Pointer drauf, damit diese .h-Datei nicht so viel includen muss. */
  DatenDatei * mLevelConf;
  /** True, wenn zur Zeit was geladen ist. */
  bool mGeladen;
  /** Liste der internen Levelnamen. */
  QVector<__String> mIntLevelNamen;
  
 public:

  /* Die ganzen nachfolgenden Variablen werden von ladLevel() gesetzt.
     Danach greifen alle anderen Objekte, die was mit dem Spiel zu tun
     haben, direkt darauf zu. */


  /***** Allgemeines *****/
  int mSpielerZahl;
  /** Interner Level-Name vom aktuellen Level. (Wird von Aufnahme
      bentigt.) */
  __String mIntLevelName;
  __String mLevelName;
  __String mLevelAutor;
  /** Der Knoten zum aktuellen Level. */
  DefKnoten * mLevelKnoten;
  /** Beschreibungstext fr den Level */
  __String mBeschreibung;
  QColor mHintergrundFarbe;
  bool mMitHintergrundbildchen;
  Bilddatei mHintergrundBild;
  /** Farbe der Schrift in dem Level:
      0 = abgedunkelt, 1 = normal, 2 = aufgehellt */
  QColor mSchriftFarbe[3];
  bool mGrasBeiKettenreaktion;
  Bilddatei mExplosionBild;
  int mPlatzAnzahlDefault;
  int mPlatzAnzahlMin;
  int mPlatzAnzahlMax;
  bool mPlatzAnzahlAndere;
  Bilddatei mPktZiffernBild[2];
  Bilddatei mDbgZiffernBild;
  __String mMusik;
  
  /** Max. Anzahl der Bilder, die ein Blop gleichzeitig malt. Wird
      (ggf.) von den Sorten erhht, wenn man sie ldt. */
  int mStapelHoehe;
  /** Anzahl der Bilder, die Blops auf Nachbarfelder malen. Der Einfachheit
      halber wird das hier fr alle Sorten aufsummiert, statt alles schn
      nach relativen Koordinaten zu trennen, etc.
      Wird auch von den Sorten erhht, wenn man sie ldt. */
  int mNachbarStapelHoehe;
  
  /***** Die Sorten *****/
 protected:
  /** Das Array, in dem alle Sorten stehen. Allerdings soll die Index-
      Menge nicht bei 0 losgehen, sondern bei blop_min_sorte. Deshalb
      gibt es in public die Variable mSorten... */
  Sorte * mSortenIntern[max_farben_zahl - blopart_min_sorte];
 public:
  /** Wird ganz am Anfang auf mSortenIntern - blopart_min_sorte
      initialisiert. */
  Sorte * * const mSorten;
  int mAnzFarben;
  int mAnzFarbnamen;
 
  /***** Hetzrand *****/
  QColor hetzrandFarbe;
  int hetzrandZeit;
  bool mMitHetzbildchen;
  Bilddatei mHetzBild;
  int mHetzrandUeberlapp;

  /***** Gras *****/
  ListenKnoten * mAnfangsZeilen;


  /***** KI-Player-Nutzen-Funktion *****/
  /** Zusatzpunkte fr beide Blops gleiche Farbe & Senkrecht*/
  int mKINEinfarbigSenkrecht;
  /** Vorfaktor vor Bewertung der Blop-Hhe */
  int mKINHoehe;
  /** Punkte fr Blob mit gleicher Farbe benachbart */
  int mKINAnFarbe;
  /** Punkte fr Blob mit Gras benachbart */
  int mKINAnGras;
  /** Punkte fr Blob mit Grauem benachbart */
  int mKINAnGrau;
  /** Punkte fr Blob zwei ber gleicher Farbe */
  int mKINZweiUeber;
	
  /***** Sonderfeatures *****/
  bool mSpiegeln;
  int mNachbarschaft; // Default-Wert fr die Sorten
  /** true bei Sechseckraster. Wird direkt aus mNachbarschaft bestimmt. */
  bool mSechseck;
  bool mMitLeerBildchen;
  int mZufallsGraue;
  	
 protected: // Protected methods
  /** Throwt, wenn der angegebene Schlssel in level.descr nicht existiert. */
  void verlangeSchluessel(const char * s) const;

};

/* Definition in leveldaten.cpp */
extern LevelDaten * ld;


#endif
