/***************************************************************************
                          prefs.cpp  -  description
                             -------------------
    begin                : Wed Jul 12 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cuyointl.h"
#include "prefs.h"

Prefs::Prefs(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
}

Prefs::~Prefs(){
}


#define tasten_y 10
#define einsp_y 150

void  Prefs::initDialog(){
  this->resize(300,240);
  this->setMinimumSize(0,0);
	this->setCaption(_("Preferences"));

  mOK= new QPushButton(this,"ok");
  mOK->setGeometry(190,200,100,30);
  mOK->setText(_("OK"));
  mOK->setDefault(true);
	connect(mOK, SIGNAL(clicked()), SLOT(accept()));

  mAbbrechen= new QPushButton(this,"abbrechen");
  mAbbrechen->setGeometry(10,200,100,30);
  mAbbrechen->setText(_("Cancel"));
	connect(mAbbrechen, SIGNAL(clicked()), SLOT(reject()));

	/* Tasten */
	for (int i = 0; i < anz_spieler_in_dlg; i++) {
		int x0 = 140 * i + 10;
	
		QGroupBox * ra = new QGroupBox(this);
    ra->setGeometry(x0, tasten_y, 130, 130);
    ra->setTitle(i ? _("Right player") : _("Left player"));

		mTasten[i][taste_links] = erzeugTastenBtn(_("Left"), x0 + 5, tasten_y + 50, false);
		mTasten[i][taste_rechts] = erzeugTastenBtn(_("Right"), x0 + 85, tasten_y + 50, false);
		mTasten[i][taste_dreh] = erzeugTastenBtn(_("Turn"), x0 + 45, tasten_y + 40, false);
		mTasten[i][taste_fall] = erzeugTastenBtn(_("Down"), x0 + 45, tasten_y + 70, true);
	}
	
	/* Welche Tasten im 1-Spieler-Modus? */
/*	mTasteEinSpieler = new ButtonGroup(this);
	mTasteEinSpieler->setGeometry
	QRadioButton * rb1 = new QRadioButton("player 1", mTasteEinSpieler);
	rb1->setGeometry(50, einsp_y, 100, 20);
	QRadioButton * rb2 = new QRadioButton("player 2", mTasteEinSpieler);	
	rb1->setGeometry(150, einsp_y, 100, 20);*/
	//QCheckBox * mTaste1Spieler = new QCheckBox(this);
	//mTaste1Spieler->setText(_("In 1-player-mode, use keys of 2nd player."));
	//mTaste1Spieler->setGeometry(10, einsp_y, 280, 20);
}

/** Erzeugt einen von diesen Buttons, in denen
		eine Taste eingegeben wird */
TastenBtn * Prefs::erzeugTastenBtn(const char * na, int x, int y, bool text_unten) {
	QLabel * la = new QLabel(this);
	la->setGeometry(x-3, y + (text_unten ? 30 : -20), 46, 20);
	la->setText(na);
	la->setAlignment(AlignCenter);
	
	TastenBtn * bu = new TastenBtn(this);
	bu->move(x, y);
	return bu;
}
