/***************************************************************************
                          cuyo.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <qapplication.h>
#include <qaccel.h>

#include "cuyointl.h"
#include "prefs.h"
#include "startatdlg.h"
#include "kiplayer.h"

#include "cuyo.h"

#define MENU_new_game 100
#define MENU_restart_level 101
#define MENU_start_at 102
#define MENU_pause_game 104
#define MENU_stop_game 105
#define MENU_preferences 110
#define MENU_quit 120

#define MENU_1_player 131
#define MENU_2_player 132
#define MENU_KI_player 133

/* # Zeitschritte, die nach der Zeitbonus-Animation noch gewartet wird */
#define nachbonus_wartezeit 20

/* Nur zur bergabe an setSpielerZahl */
#define spz_ki 3

/* Wird in main.cpp definiert */
extern bool gDebug;


Cuyo::Cuyo(QWidget*parent,const char* name):
  QWidget(parent,name),
  mZeitlupe(false), mZaehlerZeitlupe(0), mRueberReihenTest(0), mFlag(0),
  mPauseBild(0)
{

  ld = new LevelDaten();
  
  /* Fenstergre schon mal provisorisch einstellen, damit die Menleiste
     die richtige Breite kriegt */
  resize(L_fenster_breite, gry*gric + 2 * L_rand + L_oben_hoehe);
  
  /* Menleiste erzeugen */
  MenuErz();
	

  /* Fenstergre richtig einstellen */
  int L_oben = L_rand + mMenuBar->height();
  int L_fenster_hoehe = gry*gric + L_oben + 2 * L_rand + L_oben_hoehe;
  int i;
  resize(L_fenster_breite, L_fenster_hoehe);
  setMinimumSize(L_fenster_breite, L_fenster_hoehe);
  setMaximumSize(L_fenster_breite, L_fenster_hoehe);
	
  /* Fenster mit diversem Zeug fllen... */
		
  /* Punktelabel */
  for (i = 0; i < max_spielerzahl; i++) {
    punkteLabel[i] = new QLabel(this);
    punkteLabel[i]->resize(L_graslabel_breite, L_oben_hoehe);
  }
	
  punkteLabel[0]->move(L_rand, L_oben);
  punkteLabel[0]->setAlignment(AlignVCenter | AlignLeft);
  punkteLabel[1]->move(L_fenster_breite - L_rand - L_graslabel_breite, L_oben);
  punkteLabel[1]->setAlignment(AlignVCenter | AlignRight);
	

  for (i = 0; i < max_spielerzahl; i++) {
    /* Spielfeld erzeugen */
    mSpielfeld[i] = new Spielfeld(i > 0, this); // (i > 0) = rechter Spieler
    mSpielfeld[i]->move(L_rand + (grx*gric+L_rand)*i,
			L_oben + L_rand + L_oben_hoehe );

    /* Titelbild erzeugen */
    try {
      ld->ladLevel(level_titel, i + 1);
      mSpielfeld[i]->erzeugTitelbild();
    } catch (Fehler f) {
      fprintf(stderr, _("Could not load Title:\n"));
      fprintf(stderr, "%s\n", f.mText.data());
    }
  } // for i

  /* Pause-Bild laden */
  try {
    mPauseBild = new Bilddatei();
    mPauseBild->laden("pause.xpm");
  } catch (Fehler f) {
    fprintf(stderr, _("Could not load pause.xpm:\n"));
    fprintf(stderr, "%s\n", f.mText.data());
    mPauseBild = 0;
  }

  /* Signals verbinden ... */
  for (int i = 0; i < max_spielerzahl; i++) {
    __String s;
    /** VERSION wird in config.h definiert */
    s.sprintf(_("Version %s\n%s\nPlayer %d\n\n"),
	      VERSION,
	      gDebug ? _("Debug-mode (h = help)\n") : "",
	      i + 1);
    mSpielfeld[i]->setText(s);

    connect(mSpielfeld[i], SIGNAL(sigTot()),
	    SLOT(spielerTot()));
 	
    connect(mSpielfeld[i], SIGNAL(sigBekommPunkte(bool, int)),
	    SLOT(neuePunkte(bool, int)));
    connect(mSpielfeld[i], SIGNAL(sigGrasGeplatzt()),
	    SLOT(grasGeplatzt()));
    for (int j = 0; j < max_spielerzahl; j++)
      if (i != j) {
	connect(mSpielfeld[i], SIGNAL(sigSendeGraue(int)),
		mSpielfeld[j], SLOT(empfangeGraue(int)));
	connect(mSpielfeld[i], SIGNAL(sigWillReihe(int, bool &)),
		mSpielfeld[j], SLOT(gebReihe(int, bool &)));
	connect(mSpielfeld[i], SIGNAL(sigWillStein(Blop &)),
		mSpielfeld[j], SLOT(gebStein(Blop &)));
      }
    setPunkte(i, 0);
  }
	
  /* KI-Spieler erzeugen */
  mKI = new KIPlayer(mSpielfeld[1]);

  liesPreferences();	
	
  setSpielerZahl(1); // Sollte erst nach Erzeugen der Mens aufgerufen werden...

  /* Damit Weiterspielen grad nicht geht. */
  mLevelNr = 0;
		
  setGModus(gmodus_kein_spiel);
	
  mWarteAufTaste = false;
}

Cuyo::~Cuyo(){
  delete ld;
  delete mKI;
}

/**  */
void Cuyo::MenuErz(){
  mSpielMenu = new QPopupMenu;
  mSpielMenu->insertItem(_("&New Game"), MENU_new_game);
  mSpielMenu->insertItem(_("&Restart last level"), MENU_restart_level);
  mSpielMenu->insertItem(_("Start &at level..."), MENU_start_at);
  mSpielMenu->insertItem(_("&Pause Game"), MENU_pause_game);
  mSpielMenu->insertItem(_("&Stop Game"), MENU_stop_game);
  mSpielMenu->insertSeparator();
  mSpielMenu->insertItem(_("&1 Player"), MENU_1_player);
  mSpielMenu->insertItem(_("&2 Player"), MENU_2_player);
  mSpielMenu->insertItem(_("Player vs. &Computer"), MENU_KI_player);
  mSpielMenu->insertSeparator();
  mSpielMenu->insertItem(_("Pre&ferences..."), MENU_preferences);
  mSpielMenu->insertSeparator();
  mSpielMenu->insertItem(_("&Quit"), MENU_quit);

  /*
    #ifndef HAVE_KDE2
    QPopupMenu *hilfeMenu;
    __String aboutstring;
    aboutstring.sprintf(_("This is cuyo %s\nWritten by Immi\n"), VERSION);
    hilfeMenu = kapp->getHelpMenu(true, aboutstring);
    #endif
  */

  mMenuBar = new QMenuBar(this);
  mMenuBar->insertItem(_("&Game"), mSpielMenu);
  /*
    #ifndef HAVE_KDE2
    mMenuBar->insertSeparator();	
    mMenuBar->insertItem(_("&Help"), hilfeMenu);
    #endif
  */
		
  mMenuBar->setAccel(CTRL+Key_N, MENU_new_game);
  mMenuBar->setAccel(CTRL+Key_R, MENU_restart_level);
  mMenuBar->setAccel(CTRL+Key_A, MENU_start_at);
  mMenuBar->setAccel(CTRL+Key_P, MENU_pause_game);
  mMenuBar->setAccel(Key_Escape, MENU_stop_game);
  mMenuBar->setAccel(CTRL+Key_1, MENU_1_player);
  mMenuBar->setAccel(CTRL+Key_2, MENU_2_player);
  mMenuBar->setAccel(CTRL+Key_C, MENU_KI_player);
  mMenuBar->setAccel(CTRL+Key_F, MENU_preferences);
  mMenuBar->setAccel(CTRL+Key_Q, MENU_quit);
	
  mMenuBar->show();

  connect( mMenuBar, SIGNAL(activated(int)),
	   SLOT(MenuAufruf(int)) );
}

/** Fhrt alle Men-Befehle aus */
void Cuyo::MenuAufruf(int id) {
  switch (id) {
  case MENU_new_game:
    mLevelNr = 1;
    startSpiel();
    break;
			
  case MENU_restart_level:
    ASSERT(mLevelNr != 0);
    startSpiel();
    break;
			
  case MENU_start_at: {
    StartAtDlg sa(this);
						
    /* Liste der Level basteln, die gestartet werden drfen.
       Liste soll dabei nicht dauernd repainted werden. */
    sa.mLevelListe->setAutoUpdate(false);

    int glnr = mSpielerZahl > 1; // Welche Gewonnen-Liste?
    int leanz = ld->getLevelAnz();

    /* Level durchgehen */
    bool alle_gewonnen = true;
    int lenr;
    for (lenr = 1; lenr <= leanz; lenr++) {
      /* In Liste einfgen */
      __String lena = ld->getLevelName(lenr);
      __String zei;
      zei.sprintf("%d. %s", lenr, lena.data());
      sa.mLevelListe->insertItem((QString) zei);

      /* Schon mal gewonnen? */
      __String intlena= ld->getIntLevelName(lenr);
      if (!mGewonneneLevel[glnr].contains(intlena)) {
	/* Der Level war noch nicht gewonnen; also keine weiteren 
	   in die Liste */
	alle_gewonnen = false;
	break;
      }
    }
    sa.mLevelListe->setAutoUpdate(true);
    sa.mLevelListe->repaint();

    /* Versuchen zu erraten, welchen Level der User haben will */
    sa.mLevelListe->setCurrentItem((
				    mLevelNr == 0 ?
				    alle_gewonnen ? 1 : lenr
				    : mLevelNr) - 1);
			
						
    if (sa.exec()) {
      mLevelNr = sa.mLevelListe->currentItem() + 1;
      ASSERT(mLevelNr >= 1);
      startSpiel();
    }
    break;
  }

  case MENU_pause_game: {
    ASSERT(mGModus == gmodus_spiel);

    setGModus(gmodus_pause);
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->setText(_("Game paused\n\nSpace = Resume\n\n"));
    mWarteAufTaste = true;
    mWarteTimeout = 0;
    break;
  }
		
  case MENU_stop_game: {
    stopSpiel();
    for (int i = 0; i < max_spielerzahl; i++)
      mSpielfeld[i]->setText(_("Game stopped\n\n"));
    break;
  }
		
  case MENU_1_player:
    if (mSpielerZahl != 1) {
      setSpielerZahl(1);
      mLevelNr = 0;
				/* Ist restart level noch enabled? */
      aktualisiereMenuEnabled();
    }
    break;
			
  case MENU_2_player:
    if (mSpielerZahl != 2 || mGegenKI) {
      setSpielerZahl(2);
      mLevelNr = 0;
				/* Ist restart level noch enabled? */
      aktualisiereMenuEnabled();
    }
    break;

  case MENU_KI_player:
    if (mSpielerZahl != spz_ki) {
      setSpielerZahl(spz_ki);
      mLevelNr = 0;
      /* Ist restart level noch enabled? */
      aktualisiereMenuEnabled();
    }
    break;
					
  case MENU_preferences: {
    Prefs p(this);  /* this = Fenster, ber dem der Dialog liegt */
			
    /* Aktuelle Einstellungen in den Dialog schreiben */
    for (int i = 0; i < anz_spieler_in_dlg; i++)
      for (int j = 0; j < 4; j++)
	p.mTasten[i][j]->setTaste(mTasten[i][j]);
    //p.mTaste1Spieler->setChecked(mTaste1Spieler);
			
    /* Dialog ausfhren */
    if (p.exec()) {
      /* OK geklickt => Einstellungen wieder aus Dialog holen */
      for (int i = 0; i < anz_spieler_in_dlg; i++)
	for (int j = 0; j < 4; j++)
	  mTasten[i][j] = p.mTasten[i][j]->getTaste();
      //mTaste1Spieler = p.mTaste1Spieler->isChecked();
						
      schreibPreferences();
    }
    break;
  }
  
  case MENU_quit:
    qApp->quit();
    break;
  }
}



/** Startet das Spiel fr die eingestellte Spielerzahl und mit dem
    eingestellten Level */
void Cuyo::startSpiel() {

  if (mGModus != gmodus_kein_spiel)
    stopSpiel();

  if (mSpielerZahl == 1)
    mSpielfeld[1]->setText(_("Your ad here!\n\n"));
			
  for (int i = 0; i < max_spielerzahl; i++)
    setPunkte(i, 0);

  try {
    if (!startLevel())
      throw Fehler(_("There are no (more?) levels in level.descr."));

  } catch (Fehler f) {
    fprintf(stderr, f.mText.data());
    for (int i = 0; i < mSpielerZahl; i++)	
      mSpielfeld[i]->setText(f.mText);

    /* Sicherheitshalber...: */
    stopSpiel();

    return;
  }

  /* Timer erzeugen und verbinden... */	
  mTimer = new QTimer(this);
	
  connect( mTimer, SIGNAL(timeout()), SLOT(spielSchritt()) );

  mTimer->start( 80 );

  aktualisiereMenuEnabled();
}

/** stoppt das Spiel sofort (egal, ob grad ein Level luft oder nicht) */
void Cuyo::stopSpiel(){
  if (mGModus == gmodus_kein_spiel)
    return;

  stopLevel(true);
			
  delete mTimer;
	
  setGModus(gmodus_kein_spiel);
}






/** setzt Level hoch u. . */
void Cuyo::spielSchritt() {
  ASSERT(mGModus != gmodus_kein_spiel);

  /* Zeitlupen-Debug-Modus? */
  if (mZeitlupe) {
    mZaehlerZeitlupe++;
    if (mZaehlerZeitlupe == 5)
      mZaehlerZeitlupe = 0;
    else
      return;
  }
	
  /* Warten wir grad drauf, dass der Benutzer eine Taste drckt? */
  if (mWarteAufTaste) {

    if (mWarteTimeout) {
      /* Wir warten nicht beliebig lang */
      mWarteTimeout--;
      if (mWarteTimeout)
	return;
			
      /* Zu lange gewartet. Jetzt reicht's! */
      mWarteAufTaste = false;
    } else
      return;
  }

  /* Ist grade eine Pause beendet? */
  if (mGModus == gmodus_pause) {
    setGModus(gmodus_spiel);
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->setText("");
  }


  if (mGModus == gmodus_bonus_warte) {
    /* Wir haben grade ein bisschen gewartet, damit der Benutzer seine
       Level-Endpunkte bewundern kann. Jetzt geht's weiter mit dem nchsten
       Level... */
			
    /* Alten Level stoppen (ist vermutlich nicht wirklich ntig) */
    stopLevel(false);
 		
    /* neuer Level */
    mLevelNr++;
    try {
      if (!startLevel()) {
        /* Es gibt gar keine Level mehr; also Spiel beenden */
        stopSpiel();
        for (int i = 0; i < mSpielerZahl; i++) {
  	__String s;
  	s.sprintf(_("***\nYou won!!!\n\nScore: %d\n***\n\n"), mPunkte[i]);
  	mSpielfeld[i]->setText(s);
        }
        mLevelNr = 0; // Jetzt kann man nicht mehr Restart last level
      }
    } catch (Fehler f) {
      fprintf(stderr, f.mText.data());
      for (int i = 0; i < mSpielerZahl; i++)	
        mSpielfeld[i]->setText(f.mText);
  
      stopSpiel();
    }
    return;
  } 	
	
  /* Spiel grade erst gestartet? Dann Texte lschen */
  if (mGModus == gmodus_spiel_start) {
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->setText("");
    setGModus(gmodus_spiel);
  }

  /* Ok, hier kommt der eigentliche Spielschritt */
  if (mGModus != gmodus_bonus_animation) {

    try {
      
      /* Luft eine hifea-Animation oder ist normales Spiel? */
      if (mSpielfeld[0]->getHifea() ||
          mSpielerZahl == 2 && mSpielfeld[1]->getHifea()) {
        /* hifea-Animation */
        for (int i = 0; i < mSpielerZahl; i++)
          mSpielfeld[i]->hifeaSchritt();
          
      } else {
        /* Normales Spiel */
        ld->spielSchritt(); // Fr Synchron-Animationen...
        
        for (int i = 0; i < mSpielerZahl; i++)
          mSpielfeld[i]->spielSchritt();

        /* Ggf. auch einen Spielschritt fr die KI */
        if (mGegenKI)
          mKI->spielSchritt();
      }
		
        
    } catch (Fehler f) {
      /* Im Spielschritt ein Fehler aufgetreten? */
      stopSpiel();
      fprintf(stderr, _("An error occured:\n%s\n"), f.mText.data());
				
      for (int i = 0; i < mSpielerZahl; i++) {
	__String s;
	s.sprintf(_("An error occured:\n%s\n"), f.mText.data());
	mSpielfeld[i]->setText(s);
      }
      return;
    }
  }

  /* Wurde grade das restliche Gras vernichtet? Dann warten wir jetzt nur noch
     auf einen guten Moment zum beenden. mGrasDaAnz < 0 kann nicht wirklich
     vorkommen. Aber im Debug-Modus vielleicht, wenn das Gras knstlich
     auf 0 gesetzt wurde. */
  if (mGModus == gmodus_spiel && mGrasDaAnz <= 0)
    setGModus(gmodus_warte_level);
			
			
  if (mGModus == gmodus_warte_level ||
      mGModus == gmodus_warte_tot) {
    /* Spiel (Level) soll beendet werden; aber sind auch beide
       Spieler bereit? */
			
    bool bereit = true;
    for (int i = 0; i < mSpielerZahl; i++)
      if (!mSpielfeld[i]->bereitZumStoppen())
	bereit = false;

    if (bereit) {
      /* OK, alle bereit. */
			
      /* Gewonnen oder verloren? */
      if (mGModus == gmodus_warte_level) {
				
	/* Hier darf noch nicht stopLevel() aufgerufen werden, weil sonst
	   das Spielfeld nicht mehr angezeigt wird */
	
	/* Gewonnen. Level als gewonnen abspeichern. */
	/* Ein- oder Mehrspielermodus? */
	int glnr = mSpielerZahl > 1;
	__String intlena = ld->getIntLevelName(mLevelNr);
	if (!mGewonneneLevel[glnr].contains(intlena.data())) {
	  /* Level war bisher noch nie gewonnen; also in Liste einfgen */
	  mGewonneneLevel[glnr].append(intlena);
	  schreibPreferences();
	}
				
	/* Jetzt kommt die Zeitbonus-Animation */
	setGModus(gmodus_bonus_animation);
				
	/* Noch keine Bonus-Punkte */
	mZeitBonus = 0;
      } else {
	/* Spiel zu Ende weil verloren */
	stopSpiel();
				
	for (int i = 0; i < mSpielerZahl; i++) {
	  __String s;
	  s.sprintf(_("Game over\n\nScore: %d\n\n"), mPunkte[i]);
	  mSpielfeld[i]->setText(s);
	}
      }
					
    }	// Ende: if bereit
  } // Ende: if warten, bis alle fr's Spielende bereit sind


  if (mGModus == gmodus_bonus_animation) {
    /* Hetzrand runterrutschen lassen */
    bool ba_fertig;
		
    mZeitBonus += punkte_fuer_zeitbonus;

    for (int i = 0; i < mSpielerZahl; i++) {
      /* Rand runterrutschen lassen */		
      ba_fertig = mSpielfeld[i]->bonusSchritt();
 		
      /* Punkte bekommen */
      setPunkte(i, mPunkte[i] + punkte_fuer_zeitbonus);
			
      /* Neuen Text (mit neuer Punkt-Zahl) schreiben */
      __String s;
      s.sprintf(_("Level %s complete!\n\nTime Bonus: %d\nScore: %d"),
		ld->mLevelName.data(), mZeitBonus, mPunkte[i]);
      mSpielfeld[i]->setText(s);
    }
				
    /* Unten angekommen? */
    if (ba_fertig) {
      setGModus(gmodus_bonus_warte);
 			
      mWarteAufTaste = true;
      mWarteTimeout = nachbonus_wartezeit;
    } // Ende: if Bonus-Animation fertig
  } // Ende: if Bonus-Animation
}



/**  */
void Cuyo::neuePunkte(bool reSp, int pt){
  if (reSp) setPunkte(1, mPunkte[1] + pt);
  else setPunkte(0, mPunkte[0] + pt);
}


/**  */
void Cuyo::grasGeplatzt() {
  mGrasDaAnz--;
  ASSERT(mGrasDaAnz >= 0);
}


/**  */
void Cuyo::setPunkte(int sp, int pu){
  __String s;
  mPunkte[sp] = pu;
  s.sprintf("%d", pu);
  punkteLabel[sp]->setText(s);
}





/** tut alles, was beim Starten eines Levels
    getan werden muss; liefert false, wenn es
    den Level gar nicht mehr gibt. Throwt bei Fehler. */
bool Cuyo::startLevel() {

  int i;

  /* So viele Level gibt's doch gar nicht */
  if (mLevelNr > ld->getLevelAnz())
    return false;

  /* Level-Daten laden */
  for (i = 0; i < mSpielerZahl; i++) {
    __String s;
    s.sprintf(_("Score: %d\n\nLoading Level %d...\n\n"),
	      mPunkte[i], mLevelNr);
    mSpielfeld[i]->setText(s, true);
  }
  ld->ladLevel(mLevelNr, mSpielerZahl);
	
  /* Gesamtgrasmenge berechnen */
  mGrasDaAnz = ld->getGrasAnzahl() * mSpielerZahl;
	
  /* Hier ist die Stelle, wo wir darauf gucken, wie viele Spieler mitspielen;
     nur fr so viele Spieler wird das Spiel wirklich gestartet */
  for (i = 0; i < mSpielerZahl; i++) {
    mSpielfeld[i]->startLevel();
    __String s;
    s.sprintf(_("Score: %d\n\nLevel %d\n%s\n%d blops explode\n%s\n%s\n\nSpace = Start"),
	    mPunkte[i], mLevelNr, ld->mLevelName.data(), ld->mPlatzAnzahl,
	    ld->mGrasBeiKettenreaktion ? "Chain reaction necessary\n" : "",
	    ld->mBeschreibung.data());
    mSpielfeld[i]->setText(s, false);
  }

  /* Auch die KI mchte wissen, wenn ein neuer Level anfngt. */
  if (mGegenKI)
    mKI->startLevel();

	
  setGModus(gmodus_spiel_start);
  mWarteAufTaste = true;
  mWarteTimeout = 0;
  return true;
}



/** tut alles, was beim Stoppen eines Levels
    getan werden muss (ohne Animation, d. h. entweder
    ist die Animation schon vorbei oder es gibt halt keine).
    Wenn malen = true ist, Bildschirm sofort updaten */
void Cuyo::stopLevel(bool malen) {
			
  for (int i = 0; i < mSpielerZahl; i++)
    mSpielfeld[i]->stopLevel(malen);
}





/** liefert true, wenn das Spiel normal luft, false
		wenn das Spiel am zuende gehen ist */
bool Cuyo::spielLaeuft() {
  ASSERT(mGModus != gmodus_kein_spiel);
  return mGModus == gmodus_spiel || mGModus == gmodus_pause;
}



/** wird aufgerufen, wenn ein Spieler tot ist */
void Cuyo::spielerTot() {
  setGModus(gmodus_warte_tot);
}



/** wird aufgerufen, wenn der Benutzer was-auch-immer
    fertiggelesen (und eine Taste gedrckt) hat. */
void Cuyo::tasteWeiter() {
  mWarteAufTaste = false;
  mWarteTimeout = 0;
}

/** Liefert die Anzahl der Mitspieler zurck. */
bool Cuyo::getSpielerZahl() const {
  return mSpielerZahl;
}

/** Ein key-Event halt... (Kmmert sich um alle Tasten,
    die whrend des Spiels so gedrckt werden...) */
void Cuyo::keyPressEvent(QKeyEvent * e) {
  int k = e->key();
  bool acc = false;
  if (mGModus == gmodus_spiel) {
    for (int i = 0; i < max_spielerzahl; i++) {
  	
      /* Im 1-Spieler-Modus und im KI-Modus alle Tastendrcke an
	 Spieler 1 senden; sonst Tasten an die verschiedenen Spieler
	 verteilen */
      int j;
      if (mSpielerZahl == 1 || mGegenKI) j = 0; else j = i;
  		
      if (k == mTasten[i][taste_links]) {
	mSpielfeld[j]->tasteLinks();
	acc = true;
      }
      if (k == mTasten[i][taste_rechts]) {
	mSpielfeld[j]->tasteRechts();
	acc = true;
      }
      if (k == mTasten[i][taste_dreh]) {
	mSpielfeld[j]->tasteDreh();
	acc = true;
      }
      if (k == mTasten[i][taste_fall]) {
	mSpielfeld[j]->tasteFall();
	acc = true;
      }
    }
  } // if spiel luft
  if (mWarteAufTaste)
    if (k == Key_Space || k == Key_Return || k == Key_Enter) {
      tasteWeiter();
      acc = true;
    }

  /* Event noch nicht verarbeitet */
  if (!acc) {

    /* Debug-Taste? */
    if (gDebug) {
      char a = e->ascii();

      if (a == 'b') {
	for (int i = 0; i < mSpielerZahl; i++)
	  mSpielfeld[i]->empfangeGraue(1);
	fprintf(stderr, "Debug: Bekomme Graue\n");
	return; 
      }

      if (a == 'f') {
	mFlag = !mFlag;
	fprintf(stderr, "Debug: Flag = %d\n", mFlag);
	return;
      }

      if (a == 'g') {
	mGrasDaAnz = 0;
	fprintf(stderr, "Debug: Gewinnen\n");
	return;
      }

      if (a == 'h') {
	fprintf(stderr, "Debug: Hilfe\n");
	fprintf(stderr, "  b: Bekomme Graue\n");
	fprintf(stderr, "  f: Flag an/aus\n");
	fprintf(stderr, "  g: Gewinnen\n");
	fprintf(stderr, "  h: Hilfe\n");
	fprintf(stderr, "  r: Reload levelconf\n");
	fprintf(stderr, "  t: Test Rber-Reihe an/aus\n");
	fprintf(stderr, "  z: Zeitlupe an/aus\n");
	return;
      }

      if (a == 'r') {
	ld->ladLevelConf();
	fprintf(stderr, "Debug: Reload levelconf\n");
	return;
      }

      if (a == 't') {
	mRueberReihenTest = !mRueberReihenTest;
	fprintf(stderr, "Debug: Test Rber-Reihe = %d\n", mRueberReihenTest);
	return;
      }

      if (a == 'z') {
	mZeitlupe = !mZeitlupe;
	fprintf(stderr, "Debug: Zeitlupe = %d\n", mZeitlupe);
	return;
      }

    }

    e->ignore();
  }
}

/** Ldt die Preferences aus wo-auch-immer-sie-abgespeichert-werden
in die Variablen. */
void Cuyo::liesPreferences(){
	
  int i;
  ConfigDatei prd(getPrefsName());
	
  /* Tastenbelegung */
	
  /* Default-Tasten */
  int dt[max_spielerzahl][4] = {{Key_A, Key_D, Key_W, Key_S},
    {Key_Left, Key_Right, Key_Up, Key_Down}};
  char tn[4][9] = {"left", "right", "turn", "down"};
																	
  for (i = 0; i < max_spielerzahl; i++) {
    __String s;
    s.sprintf("keys %d", i + 1);
    prd.setAbschnitt(s);
    for (int j = 0; j < 4; j++)
      mTasten[i][j] = prd.getZahlEintrag(tn[j], dt[i][j]);
  }

  /* Gewonnene Level */
  prd.setAbschnitt(0);
  for (i = 0; i < 2; i++) {
    prd.getListenEintrag(i ? "wonMultiPlayer" : "wonOnePlayer", mGewonneneLevel[i]);
    /* Debug-Ausgabe: */
    /*__String t = prd->readEntry(i ? "wonMultiPlayer" : "wonOnePlayer");
      printf("blub = %s\n", t.data());*/
  }
}

/** Schreibt die Preferences nach wo-auch-immer-sie-abgespeichert-werden. */
void Cuyo::schreibPreferences(){

  QFile f(getPrefsName());
  f.open(IO_WriteOnly);
  QTextStream ts(&f);
  ts << __String("# cuyo Preferences File\n");
  ts << __String("\n");
  for (int i = 0; i < 2; i++) {
    ts << __String(i ? "wonMultiPlayer" : "wonOnePlayer") << __String("=");
    __String lena;
    for (lena = mGewonneneLevel[i].first(); lena != 0;
	 lena = mGewonneneLevel[i].next())
      ts << lena << __String(",");
    ts << __String("\n");
  }
  ts << __String("\n");
	
  char tn[4][9] = {"left", "right", "turn", "down"};
  for (int i = 0; i < max_spielerzahl; i++) {
    ts << __String("[keys ") << (i + 1) << __String("]\n");
    for (int j = 0; j < 4; j++)
      ts << __String(tn[j]) << __String("=") << mTasten[i][j] << __String("\n");
    ts << __String("\n");
  }
	
}

/** Setzt die Anzahl der Spieler. Auch in der Menleiste. */
void Cuyo::setSpielerZahl(int a){
  mGegenKI = a == spz_ki;
  mSpielerZahl = mGegenKI ? 2 : a;
  mSpielMenu->setItemChecked(MENU_1_player, a == 1);
  mSpielMenu->setItemChecked(MENU_2_player, a == 2);
  mSpielMenu->setItemChecked(MENU_KI_player, a == spz_ki);
}

/** ndert mGModus und aktualisiert das Enabled-Sein der Mens. */
void Cuyo::setGModus(int gm) {
  mGModus = gm;
  aktualisiereMenuEnabled();
}


/** Setzt das Enabled-Sein der Mens auf das Richtige,
    abhngig von mGModus und mLevelNr */
void Cuyo::aktualisiereMenuEnabled() {
  bool ks = mGModus == gmodus_kein_spiel;
  mSpielMenu->setItemEnabled(MENU_new_game, ks);
  mSpielMenu->setItemEnabled(MENU_restart_level, ks && mLevelNr > 0);
  mSpielMenu->setItemEnabled(MENU_start_at, ks);
  mSpielMenu->setItemEnabled(MENU_pause_game, mGModus == gmodus_spiel);
  mSpielMenu->setItemEnabled(MENU_stop_game, !ks);
  mSpielMenu->setItemEnabled(MENU_1_player, ks);
  mSpielMenu->setItemEnabled(MENU_2_player, ks);
  mSpielMenu->setItemEnabled(MENU_KI_player, ks);
  mSpielMenu->setItemEnabled(MENU_preferences, ks);
}

/** Liefert den Namen und Pfad der Prefs-Datei zurck
    ($HOME/.cuyo) */
__String Cuyo::getPrefsName() const{
  char * ho = getenv("HOME");
  if (!ho) {
    /* Unter Windows zum Beispiel... */
    fprintf(stderr, _("Warning: Env-Variable $HOME not found. Using the current cirectory for .cuyo"));
    return ".cuyo";
  }
  if (ho[strlen(ho) - 1] == '/')
    return __String(ho) + ".cuyo";
  else
    return __String(ho) + "/.cuyo";
}
