/***************************************************************************
                          blop.h  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BLOP_H
#define BLOP_H

#include "inkompatibel.h"

#include <qpainter.h>

#include "leveldaten.h"
#include "blopbesitzer.h"

// Bits vom Return-Wert von animiere()
#define animret_verschwinden 4		// Sollte nur das Feuer zurckliefern
#define animret_verbrennen 8			// Dito.

// Blop-Arten
#define blopart_ausserhalb -1		// wird nicht von Blop, sondern nur
// von Spielfeld verwendet
#define blopart_keins 0
#define blopart_farbe 1
#define blopart_gras 2
#define blopart_grau 3
#define blopart_blaeschen 4
#define blopart_feuer 5
//#define blopart_wirklich_keins 6	// Bei blopart_keins wird ggf. das Leerbildchen
// angezeigt. bei wirkklich_keins nicht. (Wird fr's Reihen rbergeben bentigt)
// getArt() liefert brigens trotzdem blopart_keins zurck.

// liefert getFarbe manchmal zurck
#define keine_farbe -1
//#define noch_eine_andere_farbzahl -2  // wird von Spielfeld bentigt

// Wert von mX und mY, falls das Blop nicht im Gitter ist
#define keine_koord 0x7fff

/**Diese 16x16 Pixel groen Dinge heien Blops.
   In diesem Objekt wird der Zustand eines Blops
   gespeichert (aber nicht seine Position). Es gibt auch
   den nicht-Blop.
   *@author Immi
   */

class Blop: public BlopBesitzer {
 public:
  /** Constructor... Zu den Parametern siehe setSorte(...) */
  Blop(int a = blopart_keins, int f = -1);
  /** Copy-Contructor... kmmert sich auch um's Feuer */
  Blop(const Blop & b);
  /** Destructor: ggf. mFeuer mitlschen */
  ~Blop();
	
  /** Tut, was man erwartet. (Kopiert insbesondere auch das Feuer) */
  Blop & operator=(const Blop & b);
  /** kopiert die Daten von b; liefert true, wenn
      dabei was gendert wurde */
  bool aendern(const Blop & b);
  /** fhrt die ganzen Animationen durch. Liefert
      in Bit 0 zurck, ob das Blop-Bild geupdatet werden muss.
      Liefert in Bit 1 zurck, ob die Nachbarblopbilder evtl.
      geupdatet werden mssen (weil sich die Sorte gendert hat).
      Dinge, die zu zuend hinzugefgt
      werden, sollen angezndet werden. */
  int animiere(PointList * zuendLi = 0);
  /** Startet den Platzvorgang */
  void lassPlatzen();
  /** Startet die Verbrennung dieses Blops (wenn's nicht schon brennt). */
  void starteVerbrennung();


  /////////// Funktionen, die nix verndern

  /** malt den Blop, wobei xx und yy in Pixeln
      angegeben ist; der Hintergrund wird vorher
      gelscht */
  void malen(QPainter & p, int xx, int yy
	     /*,int verbindung = verbindung_solo,
	       int feuerverbindung = 0*/) const;
  /** Liefert die Sorte zurck */
  const Sorte * getSorte() const {return mSorte;}
  /** liefert die Art zurck */
  int getArt() const;
  /** liefert die Farbe zurck, aber nur, wenns wirklich ein farbiges
      Blop ist (sonst wird keine_farbe zurckgeliefert) */
  int getFarbe() const;
  /** liefert die Version zurck. */
  int getVersion() const;
  /** liefert true, wenn der Blop am platzen ist */
  bool getAmPlatzen() const;
  /** Liefert true, wenn die Blobs so gleich sind, dass sie sich verbinden
      knnen */
  bool verbindetMit(const Blop & b) const;
  /** Liefert true, wenn beide Blobs brennen (oder einen
      Brennanschluss haben) */
  bool verbindetMitFeuer(const Blop & b) const;
  /** liefert true, wenn der Blob prinzipiell bereit ist, Verbindungen
      einzugehen */
  bool verbindbar() const;
  /** Wenn's ein Level ist, bei dem sich Blops beim Drehen
      ndern, wird dies getan */
  void drehen();
  /** Teilt einem Farbblop die (neue) Gre seiner Kette mit. */
  void setKettenGroesse(int anz);
  /** Setzt Besitzer und Besitzer-Informationen. Braucht nur am Anfang einmal
      aufgerufen zu werden. */
  void setBesitzer(BlopBesitzer * bes, int x = keine_koord, int y = keine_koord);
  /** Sagt (ggf.) dem Feuer, wie es sich verbinden kann. */
  int getBesitzVerbindungen(int x, int y, bool feuer) const;
  /** liefert true, wenn sich der Blop auch mit dem angegebenen
      Rand verbindet */
  bool verbindetMitRand(int seite) const;
  /** Liefert zurck, wie viele Punkte dieser Stein zur Kettengre
      beitrgt (normalerweise 1). */
  int getKettenBeitrag() const;
  /** Liefert die Art des Blop zurck, wie es sich verkleidet
      hat. */
  int getArtVerkleidet() const;
  /** Liefert die Farbe unter Bercksichtigung eventueller
      Verkleidungen zurck. */
  int getFarbeVerkleidet() const;

 protected:
  /** keins / farbe / gras / grau / blaeschen.
      bei art = keins mssen am_platzen und animation 0 sein.
      Achtung: Nur mit setSorte() ndern! */
  int mArt;
  /** Bei art = blobart_farbe: Farbe; bei art = blobart_gras: Gras-Nummer;
      Bei art = blopart_blaeschen: Blschenart (xpm-Zeile).
      Achtung: Nur mit setSorte() ndern! */
  int mFarbe;
  /** Zeiger auf die zu mArt und mFarbe gehrige Sorte (aus LevelDaten).
      Achtung: Nur mit setSorte() ndern! */
  const Sorte * mSorte;
  /** Der Zustand des Blops (siehe Sorte) */
  BlopZustand mZustand;
  /** aktueller Platz-Zustand; 0: platzt grade nicht */
  int mAmPlatzen;
  /** Wenn dieser Blop grade brennt, dann das Feuerblop (sonst 0) */
  Blop * mFeuer;
  /* Achtung! Beim Einfgen neuer Felder muss auch aendern(...) gendert werden.
     Und operator== vielleicht auch. */
	
  /***** Variablen, die sich nie ndern *****/
  /* Sie sollten am besten const sein; das geht aber aus technischen Grnden
     beim BlopGitter nicht.
     Sie brauchen nur am Anfang einmal gesetzt zu werden, weil sie bei
     Zuweisungen nicht (mehr) verndert werden. */
  /** ggf. Pointer auf den Besitzer dieses Blops */
  BlopBesitzer * mBesitzer;
  /** Koordinaten des Blops im BlopGitter... oder sonstige Informationen,
      die den BlopBesitzer interessieren */
  int mX, mY;
		
 protected: // Protected methods
  /** Setzt mArt, mFarbe und mSorte. Nur mit dieser Funktion
      sollte die Sorte gendert werden. Bei der Gelegenheit
      wird auch der Zustand zurckgesetzt. Und die Version wird
      neu gesetzt: Wenn keine angegeben ist, auf was zuflliges.
      (Der zweite Parameter ist die Farbe beim Farbblop und die
      Version sonst... etwas provisorisch.) */
  void setSorte(int a, int f = -1, int v = -1);
  /** Muss aufgerufen werden, wenn das Blop anders aussieht, damit
      es frisch gemalt wird. Kmmert sich drum, die gendert-Nachricht
      an die richtige Stelle weiterzuleiten. */
  void geaendert(bool auch_nachbarn);
  /** Wird ggf. vom Feuer aufgerufen */
  void besitzGeaendert(int x, int y, bool auch_nachbarn);
  /** Fragt beim Besitzer an, in welche Richtungen dieser Blop
      verbunden werden kann und liefert das zurck. Bei Feuer
      =true wird fr das Feuer dieses Blops gefragt */
  int getVerbindungen(bool feuer = false) const;
  /** Liefert die aktuelle Verkleidung dieses Blops zurck. */
  const Sorte * getVerkleidung() const;
};

#endif
