
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: pipeline.m,v 1.2 2000/08/12 11:06:50 stes Exp $
 */

#include <assert.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Object.h>
#include "process.h"
#include "pipeline.h"

@implementation Pipe

- lhs:v
{
  lhs = v; return self;
}

- rhs:v
{
  rhs = v;return self;
}

/* evaluate cmd, if mkpipe=true, return read end of pipe */
/* (allows to close file descriptors bottom up) */

- go
{
  int f,ok;

  [lhs makepipe:YES];
  [lhs setsrcfd:srcfd];

  if (errbuf) {
   [lhs seterrbuf:errbuf];
  } else {
   [lhs seterrfd:errfd];
  }

  [lhs go];

  f = [lhs pipefd];

  [rhs setsrcfd:f];

  if (errbuf) {
   [rhs seterrbuf:errbuf];
  } else {
   [rhs seterrfd:errfd];
  }

  if (makepipe) {
    [rhs makepipe:YES];
    [rhs go];
    pipefd = [rhs pipefd];
  } else {
    if (dstbuf) {
     [rhs setdstbuf:dstbuf];
    } else {
     [rhs setdstfd:dstfd];
    }
    [rhs makepipe:NO];
    [rhs go];
  }

  ok = close(f);assert(ok == 0);
  return self;
}

@end

