
/*
 * Copyright (c) 1999,2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: formfram.m,v 1.8 2000/08/12 19:30:50 stes Exp $
 */

#include <assert.h>
#include <curses.h>
#include <stdlib.h>
#include <form.h>
#include <menu.h>
#include <Object.h>
#include <ocstring.h>
#include <ordcltn.h>

#include "slk.h"
#include "var.h"
#include "frame.h"
#include "field.h"
#include "formfram.h"
#include "cursel.h"
#include "menufram.h"
#include "cmdmenu.h"

@implementation Form

- setfields:x
{
  fields = x;return self;
}

- unpost
{
  if (posted) {
    unpost_form(eti_form);
    posted = 0;
  }
  return self;
}

- destroy
{
  [self unpost];
  if (eti_form) free_form(eti_form);
  [fields elementsPerform:_cmd];
  if (eti_fields) free(eti_fields);
  eti_form = NULL;
  eti_fields = NULL;
  return [super destroy];
}

- invalidfieldmsg
{
  id x;
  FIELD *fld;
  beep();
  fld = current_field(eti_form);  
  x = (id)field_userptr(fld);
  [x invalidfieldmsg];
  return self;
}

- create
{
  id r;
  int ok;
  int h,w;
  int i,j,n;
  FIELD *f;
 
  if (eti_form) [self destroy];
 
  n = [fields size];
  [fields elementsPerform:_cmd];
  eti_fields = (FIELD**)malloc(sizeof(FIELD*) * (2 * n+1));
  for(i=0,j=0;i<n;i++) {
    id field = [fields at:i];
    [field setform:self];
    f = [field eti_field];
    eti_fields[j++] = f;  
    f = [field eti_label];
    if (f) eti_fields[j++] = f; /* below field if overlap */
  }
  eti_fields[j] = NULL;
  assert(j <= 2*n);
  eti_form = new_form(eti_fields);
  assert(eti_form);

  ok=scale_form(eti_form,&h,&w);
  assert(E_OK==ok);

  if (!framerect) {
    r = [self begframerect:w+3:h+2];
    if (r) [self setframerect:r]; else return [self frametoolarge];
  }

  eti_win=subwin(stdscr,[self height],[self width],[self top],[self left]);
  assert(eti_win);
  if (has_colors()) {
    wbkgdset(eti_win,COLOR_PAIR(colorpairs[CP_TEXT])|' ');
  }
  set_form_win(eti_form,eti_win);
  eti_subwin=derwin(eti_win,h,w+1,1,1);
  set_form_sub(eti_form,eti_subwin);
  ok=keypad(eti_subwin,TRUE);
  assert(ERR != ok);

  return self;
}

- drawframe
{
  return [self drawbox:(formtitle)?[formtitle str]:"Form"];
}

- drawscrollbar
{
  int h = [self height] - 2;
  [self drawscrollbar:0:h:h];
  return self;
}

- draw
{
  int ok;

  if (!eti_form) { if (![self create]) return nil; }

  [self drawframe];
  [self drawscrollbar];

  if (posted) [self unpost];
  werase(eti_subwin);
  ok=post_form(eti_form);
  assert(ok == E_OK);
  posted++;

  needdisplay=NO;
  return self; 
}

- setslk
{
  int n = MAXFUNKEYS;
  while (n--) slktab[n] = nil;
  slktab[1] = k_help;
  slktab[2] = k_choices;
  slktab[3] = k_save;
  slktab[4] = k_prev_frm;
  slktab[5] = k_next_frm;
  slktab[6] = k_cancel;
  slktab[7] = k_cmd_menu;
  return [super setslk];
}

- home
{
  int ok = form_driver(eti_form,REQ_FIRST_FIELD);
  if (ok != E_OK) {
     beep();
  }
  return self;
}

- arrowleft
{
  int ok = form_driver(eti_form,REQ_PREV_CHAR);
  if (ok != E_OK) beep();
  return self;
}

- arrowright
{
  int ok = form_driver(eti_form,REQ_NEXT_CHAR);
  if (ok != E_OK) beep();
  return self;
}

- spacebar
{
  beep();
  return self;
}

- end
{
  int ok = form_driver(eti_form,REQ_LAST_FIELD);
  if (ok != E_OK) {
     beep();
  }
  return self;
}

- downpage
{
  int ok = form_driver(eti_form,REQ_NEXT_PAGE);
  if (ok != E_OK) beep();
  return self;
}

- uppage
{
  int ok = form_driver(eti_form,REQ_PREV_PAGE);
  if (ok != E_OK) beep();
  return self;
}

- arrowup
{
  int ok = form_driver(eti_form,REQ_PREV_FIELD);
  if (ok != E_OK) { beep(); }
  return self;
}

- enter
{
  return [self arrowdown];
}

- controli
{
  return [self arrowdown];
}

- arrowdown
{
  int ok = form_driver(eti_form,REQ_NEXT_FIELD);
  if (ok != E_OK) { beep(); }
  return self;
}

- controlt
{
  return [self enter];
}

- controlb
{
  return [self home];
}

- controly
{
  int ok = form_driver(eti_form,REQ_CLR_FIELD);
  if (ok != E_OK) beep();
  return self;
}

- controlh
{
  int ok = form_driver(eti_form,REQ_DEL_PREV);
  if (ok != E_OK) beep();
  return self;
}

- controlx
{
  int ok = form_driver(eti_form,REQ_DEL_CHAR);
  if (ok != E_OK) beep();
  return self;
}

- controlk
{
  return [self clearEol];
}

- clearEol
{
  int ok = form_driver(eti_form,REQ_DEL_LINE);
  if (ok != E_OK) beep();
  return self;
}

- homedown
{
  return [self end];
}

- getevent
{
  int c = [self getkey];
  
  switch(form_driver(eti_form,c)) {
     case E_OK : break;
     case E_UNKNOWN_COMMAND : [self keydown:c];break;
     case E_INVALID_FIELD : [self invalidfieldmsg];break;
     default : beep(); break;
  }

  return self;
}

- deffieldvars
{
  int len;
  int i,n;
  char *s;

  for(i=0,n=[fields size];i<n;i++) {
    s = field_buffer([[fields at:i] eti_field],0);
    len = strlen(s);
    while (len && s[len-1] == ' ') {
      len--; /* strip trailing spaces */
    }
    [Var define:[[String sprintf:"F%i",i+1] str] as:[String chars:s count:len]];
  }  
  return self;
}

- undeffieldvars
{
  int i,n;
  for(i=0,n=[fields size];i<n;i++) {
    [Var undefine:[[String sprintf:"F%i",i+1] str]];
  }  
  return self;
}

- clearfields
{
  id safe = framerect;
  [self destroy];
  framerect = safe;
  [self create];
  return self;
}

- curfield
{
  FIELD *x = current_field(eti_form); return (id)field_userptr(x);
}

- setcurfield:v
{
  id f = [self curfield];
  set_field_buffer([f eti_field],0,[v str]);
  return self;
}

- choices
{
  id c,f;
  static id v; 

  f = [self curfield];
  c = [f choices];

  if (c == nil || [c size] == 0) {
    showtransientmessage("There are no choices available");
  } else { 
    if ([f needschoicewindow]) {
      id frm = [CmdMenu newchoice:c];
      runframe(frm);
    } else {
      int ok;
      ok = form_driver(eti_form,REQ_NEXT_CHOICE);
    }
  }

  return self;
}

- refresh
{
  [self clearfields]; return [super refresh];
}

- save
{
  /* validate last field */
  int ok = form_driver(eti_form,REQ_VALIDATION);

  if (done) {
    id c;
    [self deffieldvars];
    c = expandstr(done);
    [self undeffieldvars];
    if (c) evalcmd(c);
  } else {
    [self close];
  }
  return self;
}

@end
 
