/*  cssed (c) Iago Rubio 2003, 2004 - A tiny CSS editor.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

typedef struct _CssedPluginPriv CssedPluginPriv;
typedef struct _CssedPlugin CssedPlugin;

struct _CssedPlugin
{
	gchar *name; 		
	gchar *description;						
	gboolean (*load_plugin) (CssedPlugin*);	
	void (*clean_plugin) (CssedPlugin*); 	
	gpointer user_data;	
	CssedPluginPriv* priv;
};
 

/* internall use */
CssedPlugin* cssed_init_plugin( CssedWindow*, gchar* );
void cssed_load_plugin( CssedPlugin* plugin );
void cssed_unload_plugin( CssedPlugin* plugin );
gchar* cssed_plugin_get_filename( CssedPlugin* plugin );// don't free return value
gboolean cssed_is_plugin_file_loaded ( CssedWindow* window, gchar* path  );
CssedPlugin* cssed_get_plugin_if_file_loaded ( CssedWindow* window, gchar* path );

/* *************************** plugins API ***************************** */
/* *************************** UI functions **************************** */
void 
cssed_plugin_unload_callback( GtkWidget* widget, gpointer plugin );

gboolean
cssed_add_menu_item_to_plugins_menu( CssedPlugin* plugin, GtkWidget* menu_item);

gboolean
cssed_plugin_add_widget_to_toolbar( CssedPlugin* plugin, 
							 GtkWidget* widget,
							 const char *tooltip_text,
							 const char *tooltip_private_text	);
gboolean
cssed_plugin_add_page_with_widget_to_footer( CssedPlugin* plugin,
											GtkWidget* widget,
											gchar* label_text );
gboolean
cssed_plugin_remove_page_with_widget_in_footer( CssedPlugin* plugin,
											GtkWidget* widget );
gboolean
cssed_plugin_add_page_with_widget_to_sidebar( CssedPlugin* plugin,
											GtkWidget* widget,
											gchar* label_text );
gboolean
cssed_plugin_remove_page_with_widget_in_sidebar( CssedPlugin* plugin,
											GtkWidget* widget );
gboolean
cssed_plugin_select_page_with_widget_in_sidebar( CssedPlugin* plugin,
											GtkWidget* widget );
gboolean
cssed_plugin_select_page_with_widget_in_footer( CssedPlugin* plugin,
											GtkWidget* widget );

/* *************************** Dialog functions ************************ */
void
cssed_plugin_error_message( gchar* message, gchar* title );

gboolean
cssed_plugin_confirm_dialog ( gchar* message, gchar* title);

/* ************************ document funtions ************************ */
// Not added:
//	* close_doc
//	* line number funcs
//	* white spaces
//  * line endings
//  * line wrapped
//  * line endings
//  * white spaces

void
cssed_plugin_open_file( CssedPlugin* plugin, gchar* filename );
void
cssed_plugin_open_file_with_fileselector( CssedPlugin* plugin );
void 
cssed_plugin_add_text_to_document( CssedPlugin* plugin, gchar* text );
gchar*
cssed_plugin_get_text( CssedPlugin* plugin );
void
cssed_plugin_select_text_range( CssedPlugin* plugin, gint start, gint end );
gchar*
cssed_plugin_get_selected_text(  CssedPlugin* plugin  );
void
cssed_plugin_clear_selected_text( CssedPlugin* plugin );
gint
cssed_plugin_get_position_at_line ( CssedPlugin* plugin, gint line );
void
cssed_plugin_undo_document_action ( CssedPlugin* plugin );
void
cssed_plugin_redo_document_action ( CssedPlugin* plugin );
void
cssed_plugin_search_prev( CssedPlugin* plugin, gchar* text_to_search );
void
cssed_plugin_search_next( CssedPlugin* plugin, gchar* text_to_search );

/* *************************** css dialogs ***************************** */
void 
cssed_plugin_css_dialog_insert( CssedPlugin* plugin, gchar* key, gpointer class );
void 
cssed_plugin_css_dialog_remove_by_keyword( CssedPlugin* plugin, gchar* key );
gpointer 
cssed_plugin_css_dialog_lookup_by_keyword( CssedPlugin* plugin, gchar* key );
gboolean 
cssed_plugin_css_dialog_keyword_in_use( CssedPlugin* plugin, gchar* key );

/* *************************** main window object ******************** */
gpointer
cssed_plugin_get_window( CssedPlugin* plugin );



