# This script generates the misc/quickref.html file
# by Andres Cabrera June 2006
# Licensed under the GPL licence version 3 or later
# modification for empty arg in command and links on opcodes by Francois Pinot February 2007

from xml.dom import minidom
import os, glob, sys

XO = False
opcodelist = []

if sys.argv.count("-x"):
  XO = True
  file = open("opcode_listXO.txt", 'r')
  removedopcodes = file.read().split()
  file.close()

outfilename = 'misc/quickref.xml' if not XO else 'misc/quickrefXO.xml'
quickref = open(outfilename,'w')
quickref.write("\n<!-- Don't modify this file. It is generated automatically by quickref.py-->\n")
quickref.write('''<part>">
  <title>Opcode Quick Reference</title>
  <chapter id="MiscQuickref">
  <title>Opcode Quick Reference</title>''')

#categories and their order are defined here:
categories = ['Orchestra Syntax:Header',
              'Orchestra Syntax:Block Statements',
              'Orchestra Syntax:Macros',
              'Signal Generators:Additive Synthesis/Resynthesis',
              'Signal Generators:Basic Oscillators',
              'Signal Generators:Dynamic Spectrum Oscillators',
              'Signal Generators:FM Synthesis',
              'Signal Generators:Granular Synthesis',
              'Signal Generators:Hyper Vectorial Synthesis',
              'Signal Generators:Linear and Exponential Generators',
              'Signal Generators:Envelope Generators',
              'Signal Generators:Models and Emulations',
              'Signal Generators:Phasors',
              'Signal Generators:Random (Noise) Generators',
              'Signal Generators:Sample Playback',
              'Signal Generators:Scanned Synthesis',
              'Signal Generators:Table Access',
              'Signal Generators:Wave Terrain Synthesis',
              'Signal Generators:Waveguide Physical Modeling',
              'Signal I/O:File I/O',
              'Signal I/O:Signal Input',
              'Signal I/O:Signal Output',
              'Signal I/O:Software Bus',
              'Signal I/O:Printing and Display',
              'Signal I/O:Soundfile Queries',
              'Signal Modifiers:Amplitude Modifiers',
              'Signal Modifiers:Convolution and Morphing',
              'Signal Modifiers:Delay',
              'Signal Modifiers:Panning and Spatialization',
              'Signal Modifiers:Reverberation',
              'Signal Modifiers:Sample Level Operators',
              'Signal Modifiers:Signal Limiters',
              'Signal Modifiers:Special Effects',
              'Signal Modifiers:Standard Filters',
              'Signal Modifiers:Standard Filters:Resonant',
              'Signal Modifiers:Standard Filters:Control',
              'Signal Modifiers:Specialized Filters',
              'Signal Modifiers:Waveguides',
              'Signal Modifiers:Waveshaping',
              'Signal Modifiers:Comparators and Accumulators',
              'Instrument Control:Clock Control',
              'Instrument Control:Conditional Values',
              'Instrument Control:Duration Control',
              'Instrument Control:Invocation',
              'Instrument Control:Program Flow Control',
              'Instrument Control:Realtime Performance Control',
              'Instrument Control:Initialization and Reinitialization',
              'Instrument Control:Sensing and Control',
              'Instrument Control:Stacks',
              'Instrument Control:Subinstrument Control',
              'Instrument Control:Time Reading',
              'Table Control',
              'Table Control:Table Queries',
              'Table Control:Dynamic Selection',
              'Table Control:Read/Write Opreations',
              'FLTK:Containers',
              'FLTK:Valuators',
              'FLTK:Other',
              'FLTK:Appearance',
              'Mathematical Operations:Arithmetic and Logic Operations',
              'Mathematical Operations:Comparators and Accumulators',
              'Mathematical Operations:Mathematical Functions',
              'Mathematical Operations:Trigonometric Functions',
              'Mathematical Operations:Amplitude Functions',
              'Mathematical Operations:Random Functions',
              'Mathematical Operations:Opcode Equivalents of Functions',
              'Pitch Converters:Functions',
              'Pitch Converters:Tuning Opcodes',
              'Real-time MIDI:Input',
              'Real-time MIDI:Output',
              'Real-time MIDI:Converters',
              'Real-time MIDI:Generic I/O',
              'Real-time MIDI:Event Extenders',
              'Real-time MIDI:Note Output',
              'Real-time MIDI:MIDI/Score Interoperability',
              'Real-time MIDI:System Realtime',
              'Real-time MIDI:Slider Banks',
              'Spectral Processing:STFT',
              'Spectral Processing:LPC',
              'Spectral Processing:Non-Standard',
              'Spectral Processing:Streaming',
              'Spectral Processing:ATS',
              'Spectral Processing:Loris',
              'Strings:Definition',
              'Strings:Manipulation',
              'Strings:Conversion',
              'Vectorial:Tables',
              'Vectorial:Scalar operations',
              'Vectorial:Vectorial operations',
              'Vectorial:Envelopes',
              'Vectorial:Limiting and Wrapping',
              'Vectorial:Delay Paths',
              'Vectorial:Random',
              'Vectorial:Cellular Automata',
              'Zak Patch System',
              'Plugin Hosting:DSSI and LADSPA',
              'Plugin Hosting:VST',
              'OSC',
              'Network',
              'Remote Opcodes',
              'Mixer Opcodes',
              'Python Opcodes',
              'Image Processing Opcodes',
              'Miscellaneous',
              'Testing',
              'Utilities']

entries = []
for i in categories:
  entries.append([])

manualfilename = 'manual.xml' if not XO else 'manualXO.xml'
manual = open(manualfilename, 'r')
text = manual.read()
manual.close()

files = glob.glob('opcodes/*.xml')
files[len(files):]=glob.glob('opcodes/*/*.xml')
files[len(files):]=glob.glob('vectorial/*.xml')
files[len(files):]=glob.glob('utility/*.xml')
files.sort()

headerText = text[0:text.find('<book id="index"')]

for i,filename in enumerate(files):
    entry = ''
    #print file
    source = open(filename, 'r')
    # Necessary to define entities
    newfile = headerText + source.read()
    source.close()
    #print text
    xmldoc = minidom.parseString(newfile)
    xmldocId = xmldoc.documentElement.getAttribute('id')
    # Some files need special treatment (adds, dollar, divides, modulus, multiplies,
    # opbitor, opor, raises, subtracts, assign, ifdef, ifndef, define, include, undef)
    # There must be a better way to avoid loosing the entities when parsing the XML
    # file. Anyone???
    if (filename == 'opcodes' + os.sep + 'adds.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&plus;</link> b  (no rate restriction)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'dollar.xml'):
        entry = '<synopsis><link linkend="'+xmldocId+'">'+'&dollar;NAME</link>&#160;</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'divides.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&sol;</link> b  (no rate restriction)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'modulus.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&percnt;</link> b  (no rate restriction)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'multiplies.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&ast;</link> b  (no rate restriction)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'opbitor.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&verbar;</link> b  (bitwise OR)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'opor.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&verbar;&verbar;</link> b  (logical OR; not audio-rate)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'raises.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&circ;</link> b  (b not audio-rate)</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'subtracts.xml'):
        entry = '<synopsis>a <link linkend="'+xmldocId+'">'+'&minus;</link> b (no rate restriction)</synopsis>\n<para/>'
#    elif (filename == 'opcodes' + os.sep + 'assign.xml'):
#        entry = '''<synopsis> <link linkend="'+xmldocId+'">'+'&minus;</link>a  (no rate restriction)</synopsis>
#        <synopsis> <link linkend="'+xmldocId+'">'+'&plus;</link>a  (no rate restriction)</synopsis>\n'''
    elif (filename == 'opcodes' + os.sep + 'ifdef.xml'):
          entry = '<synopsis><link linkend="'+xmldocId+'">'+'&num;ifdef</link> NAME</synopsis><synopsis>  ....</synopsis>' + \
                  '<synopsis><link linkend="'+xmldocId+'">'+'&num;else</link>&#160;</synopsis><synopsis>  ....</synopsis>' + \
                  '<synopsis><link linkend="'+xmldocId+'">'+'&num;end</link>&#160;</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'ifndef.xml'):
          entry='<synopsis><link linkend="'+xmldocId+'">'+'&num;ifndef</link> NAME</synopsis><synopsis>  ....</synopsis>' + \
                '<synopsis><link linkend="'+xmldocId+'">'+'&num;else</link>&#160;</synopsis><synopsis>  ....</synopsis>' + \
                '<synopsis><link linkend="'+xmldocId+'">'+'&num;end</link>&#160;</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'define.xml'):
          entry='<synopsis><link linkend="'+xmldocId+'">'+'&num;define</link> NAME &num; replacement text &num;</synopsis><para/>\n' + \
    '<synopsis><link linkend="'+xmldocId+'">'+'&num;define</link> NAME(a&apos; b&apos; c&apos;) &num; replacement text &num;</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'include.xml'):
          entry='<synopsis><link linkend="'+xmldocId+'">'+'&num;include</link> &quot;filename&quot;</synopsis>\n<para/>'
    elif (filename == 'opcodes' + os.sep + 'undef.xml'):
          entry='<synopsis><link linkend="'+xmldocId+'">'+'&num;undef</link> NAME</synopsis>\n<para/>'
    else:
        synopsis = xmldoc.getElementsByTagName('synopsis')
        if (len(synopsis) != 0):
            # There can be more than 1 synopsis per file
            for num in range(len(synopsis)):
                tmp = synopsis[num].toxml()
                if XO:
                    opcodename = tmp[tmp.find('<command>') + 9:tmp.find('</command>')]
                else:
                    opcodename = ""
                if XO and removedopcodes.count(opcodename) == 0:
                    print "Removed ----------------------", opcodename
                else:
                    if tmp[-21:] == "</command></synopsis>":    # no arg, insert nbsp
                        tmp = tmp[:-11] + "&#160;</synopsis>"
                    tmp = tmp.replace('<command>', '<link linkend="' + xmldocId + '">')
                    entry += tmp.replace('</command>', '</link>')
            if entry != '':
                entry += '<para/>'
        else:
            #print "no synopsis tag for file: " + file
            entry = ''
    #print "Entry ------ ", entry

    info = xmldoc.getElementsByTagName('refentryinfo')
    if (len(info)!=0 and entry != ''):
        category = info[0].toxml()
        category = category[21:-23]
        print category
    else:
        print "no refentryinfo tag for file " + filename
        category = "Miscellaneous"
        if (entry!=''):
            print filename + " sent to Miscellaneous"
    #print category
    match = False
    for j, thiscategory in enumerate(categories):
        if (category == thiscategory):
            entries[j].append(entry+ '\n')
            match = True
    if match == False:
        print "WARNING! No Category Match!"

for i in range(len(categories)):
    if (len(entries[i])==0):
        print "No entries for category: "+categories[i]+"...Skipping"
        continue
    quickref.write("<para></para><formalpara>\n")
    quickref.write("<title>"+ categories[i] + "</title>\n<para>\n<para/>\n")
    count = 0
    for j in range(len(entries[i])):
        quickref.write(entries[i].pop(0)) # + '\n')
        count += 1
    quickref.write("</para></formalpara>\n<para></para>")
    print str(count) + " entries in category: " + categories[i]

quickref.write('</chapter></part>\n')
quickref.close()
print entries

