#ifndef __NeXT_NeXTDriver2D_h
#define __NeXT_NeXTDriver2D_h
//=============================================================================
//
//	Copyright (C)1999-2001 by Eric Sunshine <sunshine@sunshineco.com>
//
// The contents of this file are copyrighted by Eric Sunshine.  This work is
// distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  You may distribute this file provided that this
// copyright notice is retained.  Send comments to <sunshine@sunshineco.com>.
//
//=============================================================================
//-----------------------------------------------------------------------------
// NeXTDriver2D.h
//
//	NeXT-specific subclass of csGraphics2D which implements 2D graphic
//	functionality via the AppKit.  This file contains code which is shared
//	between the MacOS/X, MacOS/X Server 1.0 (Rhapsody), OpenStep, and
//	NextStep platforms.  See NeXTDelegate2D.h for the platform-specific
//	portion of the 2D driver implementation.
//
//-----------------------------------------------------------------------------
#if defined(__cplusplus)

#include "video/canvas/common/graph2d.h"
#include "cssys/next/NeXTAssistant.h"
#include "NeXTDelegate2D.h"
class NeXTFrameBuffer;

class NeXTDriver2D : public csGraphics2D
{
  typedef csGraphics2D superclass;

protected:
  NeXTDelegate2D controller;
  iNeXTAssistant* assistant;
  NeXTFrameBuffer* frame_buffer;

  bool init_driver(int desired_depth);
  int  get_desired_depth() const;
  int  determine_bits_per_sample(int desired_depth) const;
  void setup_rgb_15();
  void setup_rgb_32();
  void usage_summary() const;

public:
  NeXTDriver2D(iBase* p) :
    superclass(p), controller(0), assistant(0), frame_buffer(0) {}
  virtual ~NeXTDriver2D();
  virtual bool Initialize(iObjectRegistry*);
  virtual bool Open();
  virtual void Close();
  virtual void SetTitle(char const*);
  virtual void Print(csRect* = 0);
  virtual bool SetMouseCursor(csMouseCursorID);
  virtual bool HandleEvent(iEvent&);

  void user_close();
  void flush_graphics_context();
  void hide_mouse_pointer();
  void show_mouse_pointer();
  void dispatch_event(NeXTEvent, NeXTView);
};

#else // __cplusplus

#define N2D_PROTO(RET,FUNC) extern RET NeXTDriver2D_##FUNC

typedef void* NeXTDriver2D;
typedef void* NeXTEventHandle;
typedef void* NeXTViewHandle;

N2D_PROTO(void,user_close)(NeXTDriver2D);
N2D_PROTO(void,flush_graphics_context)(NeXTDriver2D);
N2D_PROTO(void,hide_mouse_pointer)(NeXTDriver2D);
N2D_PROTO(void,show_mouse_pointer)(NeXTDriver2D);
N2D_PROTO(void,dispatch_event)(NeXTDriver2D, NeXTEventHandle, NeXTViewHandle);

#undef N2D_PROTO

#endif // __cplusplus

#endif //__NeXT_NeXTDriver2D_h
