/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _ImportContactFrame_hh_
#define _ImportContactFrame_hh_

#include <wx/wx.h>
//#include <wx/notebook.h>
//#include <wx/listctrl.h>

#include <wx/toolbar.h>
#include <wx/bmpbuttn.h>

#include <wx/statusbr.h>

#include "AddressBookFrame.hh"

#include "../AddressBook.hh"
#include "../User.hh"
#include "../DirectoryService.hh"
#include "../SoftKeyStore.hh"

using namespace Cryptonit ;

class ImportContactFrame: public wxFrame
{

private:

    User *user;
    std::vector<KeyStore *> *keyStore;
    DirectoryService *dsLdap;
    
    AddressBookFrame* myParent;

    wxToolBar *icToolBar;
    wxStatusBar *importContactStatusBar;
    
    wxNotebook *importContactNotebook;
    
    void createLDAPPage(  );

    wxBoxSizer* mainSizer;    
    wxBoxSizer* ldapPageSizer;

    wxCheckBox* andCheckBox;

    wxComboBox* firstField;
    wxComboBox* firstComparaison;
    wxTextCtrl* firstParameter;
    wxComboBox* secondField;
    wxComboBox* secondComparaison;
    wxTextCtrl* secondParameter;

    wxString fieldList[ContactInfo::AttributeListLength];

    wxListCtrl* contactList;

    /* Array containing field to be displayed in the contactList */
    wxArrayString contactFieldList[2];
    bool *contactFieldListAscending;

    static const int comparaisonsOperationsSize = 5;
    wxString comparaisonsOperations[comparaisonsOperationsSize];

    void createToolBar();
    void createStatusBar();
    void initFieldList();
    int addContact( std::string contactName );

    void ldapSearch(wxCommandEvent &WXUNUSED(event));
    void ldapStop(wxCommandEvent &WXUNUSED(event));
    void viewContact(wxListEvent& event);
    void selectContact(wxListEvent& event);
    void unselectContact(wxListEvent& event);
    void enableSecondParameter(wxCommandEvent &WXUNUSED(event));
    void importContact(wxCommandEvent &WXUNUSED(event));
    void close(wxCommandEvent &WXUNUSED(event));
    void openConfig(wxCommandEvent &WXUNUSED(event));
    void onColumnClick(wxListEvent& event);

    DECLARE_EVENT_TABLE()

public:

    ImportContactFrame( AddressBookFrame* parent, 
			wxWindowID id, 
			const wxString& title, 
			User* u,
			std::vector< KeyStore*> *keySt,
			const wxPoint& pos = wxDefaultPosition, 
			const wxSize& size = wxDefaultSize, 
			long style = wxDEFAULT_FRAME_STYLE, 
			const wxString& name = _("Import Contact"));
    
    
    ~ImportContactFrame();
    
};

enum {
    IC_LDAP_SEARCH_BTN_ID = 2100,
    IC_LDAP_STOP_BTN_ID,
    IC_IMPORT_CONTACT_BTN_ID,
    IC_ACTIVATED_CONTACT_ID,
    IC_CONTACT_LIST_ID,
    IC_ENABLE_SECOND_PARAMETER_ID,
    IC_CLOSE_BTN_ID,
    IC_CONFIG_BTN_ID
};

#endif
