// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __Hero_hpp__
#define __Hero_hpp__

// Hero class
//
#include <Tracer.hpp>
#include <Character.hpp>
#include <PuckMaze.hpp>

class Hero:public Character
{
private:
    int  power;
    int  Reverse( int dir);
    Tracer *trace;

public:
    Hero( PuckMaze *maze):Character( maze),power( 10){;}
    virtual ~Hero(){};
    void Track( int element);

    virtual void Draw( void);
    virtual void Remove( void);

    virtual bool Move( int dir);
    void Update( void);
    void Check( void);

    int X( void){ return( x);}
    int Y( void){ return( y);}

    int Power( void){ return( power);}
    void Weaken( int ePower){ power -= ePower;}
    bool isAlive( void){ return( power > 0);}
};

#endif
