// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <BaseSurface.hpp>
#include <Character.hpp>

Character::Character( PuckMaze *m)
{
    maze = m;
}

//set character position
void Character::SetPosition( int newx, int newy)
{
    x = newx;
    y = newy;
}

//Add character to map
void Character::Add( void)
{
    oldx = x;
    oldy = y;
#if 0
    for( int i=0; i<9; i++)
    {
	bgPixmap[ i] = SurfaceS()->GetPixel( x + (i%3) +1, y + (i/3) +1);
    }
#endif
    Draw();
}

//Remove character from map
void Character::Remove( void)
{
#if 0
    for( int i=0; i<9; i++)
    {
	SurfaceS()->SetPixel( oldx + (i%3) +1, oldy + (i/3) +1, bgPixmap[ i]);
    }
#endif
    maze->Redraw( oldx>>2, oldy>>2, 2, 2);
}

//try to move character in given direction
bool Character::Move( int dir)
{
    if( (y&3)==0 && (x&3)==0)
    {
	if( maze->isElement( x>>2, y>>2, dir))
	{
	    return false;
	}
    }

    if( (y&3)==0 )
    {       
	switch( dir)
	{
	    case WallLT:
		x--;
		break;
	    case WallRT:
		x++;
		break;
	    default:
		break;
	}
    }

    if( (x&3)==0 )
    {       
	switch( dir)
	{
	    case WallUP:
		y--;
		break;
	    case WallDN:
		y++;
		break;
	    default:
		break;
	}
    }

    return true;
}
