// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// view.h
//
// Changes:
//   23-10-2001 - added IsFullscreen()
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_VIEW_H
#define _INCLUDE_VIEW_H

#include "SDL.h"
#include "window.h"

typedef GUI_Status (*GUIEventFilter)( SDL_Event &event, Window *window );

class View : public Surface {
public:
  View( unsigned short w, unsigned short h, short bpp, unsigned long flags );

  void SetVideoMode( unsigned short w, unsigned short h, short bpp,
                     unsigned long flags );
  void Update( void );
  void Update( const Rect &rect );
  void Refresh( void );
  void Refresh( const Rect &refresh );
  void AddWindow( Window *window );
  void SelectWindow( Window *window );
  Window *CloseWindow( Window *window );
  void CloseAllWindows( void );

  void DisableUpdates( void ) { allow_updates = false; }
  void EnableUpdates( void ) { allow_updates = true; }

  GUI_Status HandleEvents( void );
  GUI_Status FetchEvent( SDL_Event &event );
  GUI_Status PeekEvent( SDL_Event &event );
  void SetEventFilter( GUIEventFilter efilter ) { filter = efilter; }
  int ToggleFullScreen( void );
  bool IsFullScreen( void ) const { return (s_surface->flags & SDL_FULLSCREEN) != 0; }

  void SetSmallFont( Font *font ) { sfont = font; }
  void SetLargeFont( Font *font ) { lfont = font; }
  Font *SmallFont( void ) const { return sfont; }
  Font *LargeFont( void ) const { return lfont; }

private:
  List windows;
  Font *sfont, *lfont;  // small and large fonts
  bool allow_updates;

  GUIEventFilter filter;
};

#endif	/* _INCLUDE_VIEW_H */

