// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// sound.h
//
// Changes:
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_SOUND_H
#define _INCLUDE_SOUND_H

#include "SDL.h"

int init_audio( bool state );
void shutdown_audio( void );
void play_audio( unsigned short sfxid, unsigned short flags );
void wait_audio( void );
bool get_audio( void );
bool toggle_audio( void );

class SoundEffect {
public:
  SoundEffect( const char *file );
  ~SoundEffect( void );

  void Play( unsigned short flags );
  void Stop( void ) const;
  void FillBuffer( void ) const;

private:
  SDL_AudioSpec spec;
  Uint8 *data;
  Uint32 len;
  bool ok;
};

// flags for SoundEffect::Play()
#define SFX_WAIT	0x0001	// return when sound has finished
#define SFX_LOOP	0x0002	// loop effect (does not work with SFX_WAIT)


// sound effect identifiers
#define SND_GUI_ERROR		0
#define SND_GUI_PRESSED		1
#define SND_GUI_MENU_SHOW	2
#define SND_GUI_ASK		3

#define SND_GAM_SELECT		4
#define SND_GAM_REPAIR		5


#endif	/* _INCLUDE_SOUND_H */

