/* cfed -- a level editor for Crimson Fields
   Copyright (C) 2000, 2001 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* ed_data.c */

#include "editor.h"

const struct TerrainType TModels[] = {
  { TT_PLAINS,          0,   0,   0,  3,  0, 0x005e8e34 },      /* plains */
  { TT_FOREST,         10,   5,   8,  4,  0, 0x002e5614 },      /* forest */
  { TT_MOUNTAINS,       9,  10,  10,  5,  0, 0x00b2b6b4 },      /* mountains */
  { TT_WATER_SHALLOW,  18,   0,   0,  3,  0, 0x005696bc },      /* shallow water */
  { TT_WATER_DEEP,     19,   0,   0,  3,  0, 0x00327694 },      /* deep water */
  { TT_ENTRANCE,       16,   0,   0,  2,  0, 0x00fea604 },      /* hq pl.1, eastern */
  { TT_ENTRANCE,       17,   0,   0,  2,  0, 0x000a72fc },      /* hq pl.2, eastern */
  { TT_ENTRANCE,       15,   0,   0,  2,  0, 0x008eaac4 },      /* hq neutral, eastern */
  { TT_KEEP_OFF,       11,   0,   0, -1,  0, 0x008a7664 },      /* structure, western */
  { TT_KEEP_OFF,       12,   0,   0, -1,  0, 0x008a7664 },      /* structure, northern */
  { TT_KEEP_OFF,       13,   0,   0, -1,  0, 0x008a7664 },      /* structure, southern */
  { TT_SWAMP,          36,  -6,  -4,  5,  0, 0x00324624 },      /* swamp */
  { TT_ROAD,            1,   3,  -3,  2,  0, 0x00322204 },      /* road, se-nw */
  { TT_ROAD,            2,   3,  -3,  2,  0, 0x00322204 },      /* road, s-n */
  { TT_ROAD,            3,   3,  -3,  2,  0, 0x00322204 },      /* road, sw-ne */
  { TT_ROAD,            4,   3,  -3,  2,  0, 0x00322204 },      /* road, sw-n-ne */
  { TT_ROAD,            5,   3,  -3,  2,  0, 0x00322204 },      /* road, se-n-nw */
  { TT_ROAD,            6,   3,  -3,  2,  0, 0x00322204 },      /* road, s-se-n-nw */
  { TT_ROAD,            7,   3,  -3,  2,  0, 0x00322204 },      /* road, s-sw-n-ne */
  { TT_ROAD,            8,   3,  -3,  2,  0, 0x00322204 },      /* road, sw-se-nw-ne */
  { TT_ROAD,           23,   3,  -3,  2,  0, 0x00322204 },      /* road, s-sw-ne */
  { TT_ROAD,           24,   3,  -3,  2,  0, 0x00322204 },      /* road, s-se-nw */
  { TT_ROAD,           25,   3,  -3,  2,  0, 0x00322204 },      /* road, se-n */
  { TT_ROAD,           26,   3,  -3,  2,  0, 0x00322204 },      /* road, sw-n */
  { TT_ROAD,           28,   3,  -3,  2,  0, 0x00322204 },      /* road, s-nw */
  { TT_ROAD,           29,   3,  -3,  2,  0, 0x00322204 },      /* road, s-ne */
  { TT_ROAD,           20,   3,  -3,  2,  0, 0x00322204 },      /* bridge, s-n */
  { TT_ROAD,           21,   3,  -3,  2,  0, 0x00322204 },      /* bridge, sw-ne */
  { TT_ROAD,           22,   3,  -3,  2,  0, 0x00322204 },      /* bridge, se-nw */
  { TT_ENTRANCE,       34,   0,   0,  2,  0, 0x00fea604 },      /* depot, pl.1, northern */
  { TT_ENTRANCE,       35,   0,   0,  2,  0, 0x000a72fc },      /* depot, pl.2, northern */
  { TT_ENTRANCE,       33,   0,   0,  2,  0, 0x008eaac4 },      /* depot, neutral, northern */
  { TT_KEEP_OFF,       14,   0,   0, -1,  0, 0x008a7664 },      /* structure, eastern */
  { TT_ROAD,           27,   3,  -3,  2,  0, 0x00322204 },      /* road, sw-se */
  { TT_ROAD,           38,   3,  -3,  2,  0, 0x00322204 },      /* road, nw-ne */
  { TT_ENTRANCE,       31,   0,   0,  2,  0, 0x00fea604 },      /* factory, pl.1, northern */
  { TT_ENTRANCE,       32,   0,   0,  2,  0, 0x000a72fc },      /* factory, pl.2, northern */
  { TT_ENTRANCE,       30,   0,   0,  2,  0, 0x008eaac4 },      /* factory, neutral, northern */
  { TT_BARRICADES,     54,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     55,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     56,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     57,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     58,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     59,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     60,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     61,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     62,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     63,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     64,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     65,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     66,   4,   5,  4,  0, 0x00969a84 },      /* fence */
  { TT_BARRICADES,     37,  -5,  -5,  4,  0, 0x00969a84 },      /* cliff */
  { TT_ENTRANCE,       70,   0,   0,  2,  0, 0x00fea604 },      /* city, pl.1 */
  { TT_ENTRANCE,       71,   0,   0,  2,  0, 0x000a72fc },      /* city, pl.2 */
  { TT_ENTRANCE,       69,   0,   0,  2,  0, 0x008eaac4 },      /* city. neutral */
  { TT_ENTRANCE,       44,   0,   0,  2,  0, 0x00fea604 },      /* hq, pl.1, western */
  { TT_ENTRANCE,       45,   0,   0,  2,  0, 0x000a72fc },      /* hq, pl.2, western */
  { TT_ENTRANCE,       43,   0,   0,  2,  0, 0x008eaac4 }       /* hq, neutral, western */
};

const struct UnitType UModels[] = {
  { TT_STD_GROUND|TT_SWAMP|TT_MOUNTAINS|TT_BARRICADES, 84, 9, 2, U_GROUND|U_CONQUER, 10, 10, 10, 8, 0, 1, 1, 1, 1, 1, 1, 0, 0, 8, 8, 255, 255, 0, 0, 0, "Infantry" },
  { TT_STD_GROUND, 72, 13, 20, U_GROUND, 15, 15, 15, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 20, 20, 255, 255, 0, 0, 1, "Medium Tanks" },
  { TT_STD_GROUND, 312, 11, 50, U_GROUND, 20, 20, 20, 10, 0, 1, 1, 1, 1, 1, 1, 0, 0, 28, 30, 255, 255, 0, 0, 2, "Heavy Tanks" },
  { TT_STD_GROUND|TT_MOUNTAINS|TT_BARRICADES, 108, 14, 20, U_GROUND, 15, 12, 12, 20, 0, 1, 1, 1, 1, 1, 1, 0, 0, 15, 16, 255, 255, 0, 0, 3, "Anti-Aircraft Tanks" },
  { TT_ROAD|TT_PLAINS|TT_ENTRANCE, 192, 8, 60, U_GROUND|U_SLOW, 8, 0, 0, 25, 0, 0, 0, 0, 0, 2, 6, 0, 0, 8, 18, 255, 255, 0, 0, 4, "Anti-Aircraft Guns" },
  { TT_ROAD|TT_PLAINS|TT_ENTRANCE, 96, 8, 65, U_GROUND|U_SLOW, 8, 20, 20, 0, 0, 2, 6, 2, 6, 0, 0, 0, 0, 10, 28, 255, 255, 0, 0, 5, "Artillery" },
  { TT_STD_SEA, 216, 0, 1, U_MINE|U_SHIP|U_GROUND, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 255, 255, 0, 0, 6, "Mines" },
  { TT_STD_SEA, 120, 12, 50, U_SHIP, 13, 12, 12, 8, 0, 1, 1, 1, 1, 1, 1, 0, 0, 18, 18, 255, 255, 0, 0, 7, "Patrol Boats" },
  { TT_STD_AIR, 144, 16, 30, U_AIR, 12, 10, 10, 16, 0, 1, 1, 1, 1, 1, 1, 0, 0, 20, 20, 255, 255, 0, 0, 8, "Fighter Squadron" },
  { TT_ROAD|TT_PLAINS|TT_ENTRANCE, 168, 14, 40, U_GROUND|U_TRANSPORT, 12, 8, 8, 6, 0, 1, 1, 1, 1, 1, 1, 0, 0, 10, 12, 255, 255, 4, 2, 9, "Personnel Carriers" },
  { TT_WATER_DEEP, 156, 10, 150, U_SHIP|U_TRANSPORT, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 18, 255, 255, 8, 100, 10, "Troopships" },
  { TT_STD_AIR, 132, 14, 50, U_AIR|U_TRANSPORT, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 22, 255, 255, 4, 70, 11, "Transport Planes" },
  { TT_ROAD|TT_PLAINS|TT_ENTRANCE, 228, 15, 15, U_GROUND, 10, 13, 10, 0, 0, 1, 2, 1, 2, 0, 0, 0, 0, 12, 16, 255, 255, 0, 0, 12, "Scouts" },
  { TT_STD_AIR, 240, 18, 25, U_AIR, 12, 0, 0, 25, 0, 0, 0, 0, 0, 1, 1, 0, 0, 17, 15, 255, 255, 0, 0, 13, "Interceptors" },
  { TT_STD_GROUND, 252, 0, 250, U_GROUND, 22, 18, 18, 15, 0, 1, 2, 1, 2, 1, 1, 0, 0, 30, 26, 255, 255, 0, 0, 14, "Bunkers" },
  { TT_STD_SEA, 264, 12, 60, U_SHIP, 15, 8, 12, 0, 12, 1, 1, 1, 2, 0, 0, 1, 1, 20, 20, 255, 255, 0, 0, 15, "Torpedo Boats" },
  { TT_STD_AIR, 276, 14, 40, U_AIR, 15, 18, 18, 8, 0, 1, 1, 1, 1, 1, 1, 0, 0, 25, 32, 255, 255, 0, 0, 16, "Bomber Wing" },
  { TT_STD_GROUND|TT_SWAMP|TT_WATER_SHALLOW, 288, 12, 40, U_GROUND|U_SHIP|U_TRANSPORT, 12, 12, 12, 8, 0, 1, 1, 1, 1, 1, 1, 0, 0, 15, 20, 255, 255, 4, 20, 17, "Hovercraft" },
  { TT_STD_AIR, 300, 12, 40, U_AIR, 16, 13, 13, 10, 0, 1, 1, 1, 1, 1, 1, 0, 0, 25, 26, 255, 255, 0, 0, 18, "Gunships" }
};

